/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_compatibility.module.common.LetsDoLegacyModule;
import steve_gall.minecolonies_compatibility.module.common.OptionalModule;
import steve_gall.minecolonies_compatibility.module.common.ae2.AppliedEnergistics2Module;
import steve_gall.minecolonies_compatibility.module.common.aether.AetherModule;
import steve_gall.minecolonies_compatibility.module.common.ars_nouveau.ArsNouveauModule;
import steve_gall.minecolonies_compatibility.module.common.atmospheric.AtmosphericModule;
import steve_gall.minecolonies_compatibility.module.common.blue_skies.BlueSkiesModule;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.ButchercraftModule;
import steve_gall.minecolonies_compatibility.module.common.butchersdelight.ButchersDelightModule;
import steve_gall.minecolonies_compatibility.module.common.cobblemon.CobblemonModule;
import steve_gall.minecolonies_compatibility.module.common.collectorsreap.CollectorsReapModule;
import steve_gall.minecolonies_compatibility.module.common.croptopia.CroptopiaModule;
import steve_gall.minecolonies_compatibility.module.common.cyclic.CyclicModule;
import steve_gall.minecolonies_compatibility.module.common.delightful.DelightfulModule;
import steve_gall.minecolonies_compatibility.module.common.ewewukeks_musketmod.ewewukekMusketModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.FarmersDelightModule;
import steve_gall.minecolonies_compatibility.module.common.fruitfulfun.FruitfulFunModule;
import steve_gall.minecolonies_compatibility.module.common.functionalstorage.FunctionalStorageModule;
import steve_gall.minecolonies_compatibility.module.common.ie.IEModule;
import steve_gall.minecolonies_compatibility.module.common.jade.JadeModule;
import steve_gall.minecolonies_compatibility.module.common.lets_do_bakery.LetsDoBakeryModule;
import steve_gall.minecolonies_compatibility.module.common.lets_do_brewery.LetsDoBreweryModule;
import steve_gall.minecolonies_compatibility.module.common.lets_do_candlelight.LetsDoCandlelightModule;
import steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.LetsDoMeadowModule;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.LetsDoVineryModule;
import steve_gall.minecolonies_compatibility.module.common.minecraft.MinecraftModule;
import steve_gall.minecolonies_compatibility.module.common.neapolitan.NeapolitanModule;
import steve_gall.minecolonies_compatibility.module.common.nethersdelight.NethersDelightModule;
import steve_gall.minecolonies_compatibility.module.common.oreberries.OreberriesModule;
import steve_gall.minecolonies_compatibility.module.common.pamhc2trees.PamsHarvestCraft2TreesModule;
import steve_gall.minecolonies_compatibility.module.common.polymorph.PolymorphModule;
import steve_gall.minecolonies_compatibility.module.common.refinedstorage.RefinedStorageModule;
import steve_gall.minecolonies_compatibility.module.common.regions_unexplored.RegionsUnexploredModule;
import steve_gall.minecolonies_compatibility.module.common.reliquary.ReliquaryModule;
import steve_gall.minecolonies_compatibility.module.common.storagedrawers.StorageDrawersModule;
import steve_gall.minecolonies_compatibility.module.common.storagenetwork.StorageNetworkModule;
import steve_gall.minecolonies_compatibility.module.common.tacz.TACZModule;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.TConstructModule;
import steve_gall.minecolonies_compatibility.module.common.thermal.ThermalModule;
import steve_gall.minecolonies_compatibility.module.common.tinkerslevellingaddon.TinkersLevellingAddonModule;
import steve_gall.minecolonies_compatibility.module.common.undergarden.UndergardenModule;

public class ModuleManager {
    private static final List<OptionalModule<?>> _MODULES = new ArrayList();
    public static final List<OptionalModule<?>> MODULES = Collections.unmodifiableList(_MODULES);
    private static boolean INITIALIZED;
    private static final List<OptionalModule<?>> _LOADED_MODULES;
    public static final List<OptionalModule<?>> LOADED_MODULES;
    public static final OptionalModule<MinecraftModule> MINECRAFT;
    public static final OptionalModule<AppliedEnergistics2Module> AE2;
    public static final OptionalModule<AetherModule> AETHER;
    public static final OptionalModule<ArsNouveauModule> ARS_NOUVEAU;
    public static final OptionalModule<AtmosphericModule> ATMOSPHERIC;
    public static final OptionalModule<BlueSkiesModule> BLUE_SKIES;
    public static final OptionalModule<ButchercraftModule> BUTCHERCRAFT;
    public static final OptionalModule<ButchersDelightModule> BUTCHERSDELIGHT;
    public static final OptionalModule<AbstractModule> BUTCHERSDELIGHTFOODS;
    public static final OptionalModule<CobblemonModule> COBBLEMON;
    public static final OptionalModule<CollectorsReapModule> COLLECTORSREAP;
    public static final OptionalModule<CroptopiaModule> CROPTOPIA;
    public static final OptionalModule<CyclicModule> CYCLIC;
    public static final OptionalModule<DelightfulModule> DELIGHTFUL;
    public static final OptionalModule<ewewukekMusketModule> EWEWUKEK_MUSKET;
    public static final OptionalModule<FarmersDelightModule> FARMERSDELIGHT;
    public static final OptionalModule<FruitfulFunModule> FRUITFULFUN;
    public static final OptionalModule<FunctionalStorageModule> FUNCTIONALSTORAGE;
    public static final OptionalModule<IEModule> IE;
    public static final OptionalModule<JadeModule> JADE;
    public static final OptionalModule<LetsDoBakeryModule> LETS_DO_BAKERY;
    public static final OptionalModule<LetsDoBreweryModule> LETS_DO_BREWERY;
    public static final OptionalModule<LetsDoCandlelightModule> LETS_DO_CANDLELIGHT;
    public static final OptionalModule<LetsDoMeadowModule> LETS_DO_MEADOW;
    public static final OptionalModule<LetsDoVineryModule> LETS_DO_VINERY;
    public static final OptionalModule<NeapolitanModule> NEAPOLITAN;
    public static final OptionalModule<NethersDelightModule> NETHERS_DELIGHT;
    public static final OptionalModule<OreberriesModule> OREBERRIES;
    public static final OptionalModule<PamsHarvestCraft2TreesModule> PHC2TREES;
    public static final OptionalModule<PolymorphModule> POLYMORPH;
    public static final OptionalModule<RefinedStorageModule> REFINEDSTORAGE;
    public static final OptionalModule<RegionsUnexploredModule> REGIONS_UNEXPLORED;
    public static final OptionalModule<ReliquaryModule> RELIQUARY;
    public static final OptionalModule<StorageNetworkModule> STORAGENETWORK;
    public static final OptionalModule<StorageDrawersModule> STORAGESDRAWERS;
    public static final OptionalModule<TACZModule> TACZ;
    public static final OptionalModule<TConstructModule> TCONSTRUCT;
    public static final OptionalModule<ThermalModule> THERMAL;
    public static final OptionalModule<TinkersLevellingAddonModule> TINKERSLEVELLINGADDON;
    public static final OptionalModule<UndergardenModule> UNDERGARDEN;

    private static <MODULE extends AbstractModule> OptionalModule<MODULE> register(String modid, Supplier<Supplier<MODULE>> initializer) {
        return ModuleManager.register(modid, OptionalModule::new, initializer);
    }

    private static <WRAPPER extends OptionalModule<MODULE>, MODULE extends AbstractModule> WRAPPER register(String modid, BiFunction<String, Supplier<Supplier<MODULE>>, WRAPPER> wrapper, Supplier<Supplier<MODULE>> initializer) {
        OptionalModule module = (OptionalModule)wrapper.apply(modid, initializer);
        _MODULES.add(module);
        return (WRAPPER)module;
    }

    public static boolean isInitialized() {
        return INITIALIZED;
    }

    public static void initialize() {
        if (INITIALIZED) {
            throw new IllegalCallerException();
        }
        INITIALIZED = true;
        _LOADED_MODULES.clear();
        for (OptionalModule<?> module : MODULES) {
            module.tryLoad();
            if (!module.isLoaded()) continue;
            _LOADED_MODULES.add(module);
        }
    }

    static {
        _LOADED_MODULES = new ArrayList();
        LOADED_MODULES = Collections.unmodifiableList(_LOADED_MODULES);
        MINECRAFT = ModuleManager.register("minecraft", () -> MinecraftModule::new);
        AE2 = ModuleManager.register("ae2", () -> AppliedEnergistics2Module::new);
        AETHER = ModuleManager.register("aether", () -> AetherModule::new);
        ARS_NOUVEAU = ModuleManager.register("ars_nouveau", () -> ArsNouveauModule::new);
        ATMOSPHERIC = ModuleManager.register("atmospheric", () -> AtmosphericModule::new);
        BLUE_SKIES = ModuleManager.register("blue_skies", () -> BlueSkiesModule::new);
        BUTCHERCRAFT = ModuleManager.register("butchercraft", () -> ButchercraftModule::new);
        BUTCHERSDELIGHT = ModuleManager.register("butchersdelight", () -> ButchersDelightModule::new);
        BUTCHERSDELIGHTFOODS = ModuleManager.register("butchersdelightfoods", () -> AbstractModule::new);
        COBBLEMON = ModuleManager.register("cobblemon", () -> CobblemonModule::new);
        COLLECTORSREAP = ModuleManager.register("collectorsreap", () -> CollectorsReapModule::new);
        CROPTOPIA = ModuleManager.register("croptopia", () -> CroptopiaModule::new);
        CYCLIC = ModuleManager.register("cyclic", () -> CyclicModule::new);
        DELIGHTFUL = ModuleManager.register("delightful", () -> DelightfulModule::new);
        EWEWUKEK_MUSKET = ModuleManager.register("musketmod", () -> ewewukekMusketModule::new);
        FARMERSDELIGHT = ModuleManager.register("farmersdelight", () -> FarmersDelightModule::new);
        FRUITFULFUN = ModuleManager.register("fruitfulfun", () -> FruitfulFunModule::new);
        FUNCTIONALSTORAGE = ModuleManager.register("functionalstorage", () -> FunctionalStorageModule::new);
        IE = ModuleManager.register("immersiveengineering", () -> IEModule::new);
        JADE = ModuleManager.register("jade", () -> JadeModule::new);
        LETS_DO_BAKERY = ModuleManager.register("bakery", LetsDoLegacyModule::new, () -> LetsDoBakeryModule::new);
        LETS_DO_BREWERY = ModuleManager.register("brewery", LetsDoLegacyModule::new, () -> LetsDoBreweryModule::new);
        LETS_DO_CANDLELIGHT = ModuleManager.register("candlelight", LetsDoLegacyModule::new, () -> LetsDoCandlelightModule::new);
        LETS_DO_MEADOW = ModuleManager.register("meadow", () -> LetsDoMeadowModule::new);
        LETS_DO_VINERY = ModuleManager.register("vinery", () -> LetsDoVineryModule::new);
        NEAPOLITAN = ModuleManager.register("neapolitan", () -> NeapolitanModule::new);
        NETHERS_DELIGHT = ModuleManager.register("nethersdelight", () -> NethersDelightModule::new);
        OREBERRIES = ModuleManager.register("oreberriesreplanted", () -> OreberriesModule::new);
        PHC2TREES = ModuleManager.register("pamhc2trees", () -> PamsHarvestCraft2TreesModule::new);
        POLYMORPH = ModuleManager.register("polymorph", () -> PolymorphModule::new);
        REFINEDSTORAGE = ModuleManager.register("refinedstorage", () -> RefinedStorageModule::new);
        REGIONS_UNEXPLORED = ModuleManager.register("regions_unexplored", () -> RegionsUnexploredModule::new);
        RELIQUARY = ModuleManager.register("reliquary", () -> ReliquaryModule::new);
        STORAGENETWORK = ModuleManager.register("storagenetwork", () -> StorageNetworkModule::new);
        STORAGESDRAWERS = ModuleManager.register("storagedrawers", () -> StorageDrawersModule::new);
        TACZ = ModuleManager.register("tacz", () -> TACZModule::new);
        TCONSTRUCT = ModuleManager.register("tconstruct", () -> TConstructModule::new);
        THERMAL = ModuleManager.register("thermal", () -> ThermalModule::new);
        TINKERSLEVELLINGADDON = ModuleManager.register("tinkerslevellingaddon", () -> TinkersLevellingAddonModule::new);
        UNDERGARDEN = ModuleManager.register("undergarden", () -> UndergardenModule::new);
    }
}

