/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.init.ModMenuTypes;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;

public class StonecutterTeachMenu
extends TeachRecipeMenu<StonecutterRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int INGREDIENT_X = 44;
    public static final int INGREDIENT_Y = 35;
    public static final int RESULT_X = 116;
    public static final int RESULT_Y = 35;

    public StonecutterTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModMenuTypes.STONECUTTING_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public StonecutterTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModMenuTypes.STONECUTTING_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 1);
        this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, 0, 44, 35)));
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, 0, 116, 35)));
    }

    @Override
    protected IMenuRecipeValidator<StonecutterRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<StonecutterRecipe, Container>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<StonecutterRecipe> getRecipeType() {
                return RecipeType.f_44112_;
            }

            @Override
            protected boolean test(StonecutterRecipe recipe, Container container, ServerPlayer player) {
                return recipe.m_5818_(container, this.level);
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull StonecutterRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        ListTag input = payload.m_128437_("input", 10);
        this.inputContainer.m_6836_(0, ItemStack.m_41712_((CompoundTag)input.m_128728_(0)));
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        if (this.recipe != null) {
            this.resultContainer.m_6836_(0, ((StonecutterRecipe)this.recipe).m_5874_((Container)this.inputContainer, registryAccess));
        } else {
            this.resultContainer.m_6836_(0, ItemStack.f_41583_);
        }
    }
}

