/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.pathfinding;

import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherBlockContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.ButcherPositionsPathResult;
import steve_gall.minecolonies_tweaks.api.common.pathfinding.SimplePathJob;

public class PathJobFindButcherPosition
extends SimplePathJob<ButcherPositionsPathResult> {
    public int vertialRange = 0;
    public final Set<ResourceLocation> exceptButcherables = new HashSet<ResourceLocation>();
    public final Set<BlockPos> positions = new HashSet<BlockPos>();
    public final Set<CustomizedButcherable> blocks = new HashSet<CustomizedButcherable>();
    public final Set<CustomizedButcherable> tables = new HashSet<CustomizedButcherable>();

    public PathJobFindButcherPosition(@NotNull Level level, @NotNull BlockPos start, @NotNull BlockPos home, int range, @Nullable Mob entity) {
        super(level, start, home, range, entity, (PathResult)new ButcherPositionsPathResult());
    }

    public PathJobFindButcherPosition(@NotNull Level level, @NotNull BlockPos start, @NotNull BoundingBox restrictionBox, @Nullable Mob entity) {
        super(level, start, restrictionBox, entity, (PathResult)new ButcherPositionsPathResult());
    }

    protected boolean isTarget(@NotNull BlockPos.MutableBlockPos pos) {
        int y = pos.m_123342_();
        for (int i = 0; i <= this.vertialRange; ++i) {
            if (!super.isTarget(pos.m_142448_(y + i))) continue;
            return true;
        }
        return false;
    }

    protected boolean testPos(@NotNull BlockPos.MutableBlockPos pos) {
        ButcherBlockContext context = new ButcherBlockContext(this.world, (BlockPos)pos, this.world.m_8055_((BlockPos)pos));
        for (CustomizedButcherable butcherable : CustomizedButcherable.getRegistry().values()) {
            if (this.exceptButcherables.contains(butcherable.getId()) || this.positions.contains(pos)) continue;
            if (butcherable.isButcheringBlock(context)) {
                if (this.blocks.contains(butcherable)) continue;
                ((ButcherPositionsPathResult)this.getResult()).blocks.add(pos.m_7949_());
                this.blocks.add(butcherable);
                this.positions.add(pos.m_7949_());
                break;
            }
            if (!butcherable.isTableBlock(context) || this.tables.contains(butcherable)) continue;
            ((ButcherPositionsPathResult)this.getResult()).tables.add(pos.m_7949_());
            this.tables.add(butcherable);
            this.positions.add(pos.m_7949_());
            break;
        }
        return false;
    }
}

