/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.minecraft.util.Mth;
import net.minecraftforge.common.ForgeConfigSpec;

public class MoveSpeedConfig {
    public final ForgeConfigSpec.DoubleValue base;
    public final ForgeConfigSpec.DoubleValue increasePerSkillLevel;
    public final ForgeConfigSpec.DoubleValue increasePerBuildingLevel;

    public MoveSpeedConfig(ForgeConfigSpec.Builder builder, DefaultValues defaultValues) {
        this.base = builder.defineInRange("base", defaultValues.base(), 0.1, 2.0);
        this.increasePerSkillLevel = builder.defineInRange("increasePerSkillLevel", defaultValues.increasePerSkillLevel(), 0.0, 24.0);
        this.increasePerBuildingLevel = builder.defineInRange("increasePerBuildingLevel", defaultValues.increasePerBuildingLevel(), 0.0, 24.0);
    }

    public double apply(AbstractEntityCitizen user, int skillLevel) {
        IBuilding building = user.getCitizenData().getWorkBuilding();
        double speed = (Double)this.base.get();
        speed += (Double)this.increasePerSkillLevel.get() * (double)skillLevel;
        return Mth.m_14008_((double)(speed += (Double)this.increasePerBuildingLevel.get() * (double)(building != null ? building.getBuildingLevel() - 1 : 0)), (double)0.1, (double)2.0);
    }

    public static class DefaultValues {
        private double base;
        private double increasePerSkillLevel;
        private double increasePerBuildingLevel;

        public double base() {
            return this.base;
        }

        public DefaultValues base(double base) {
            this.base = base;
            return this;
        }

        public double increasePerSkillLevel() {
            return this.increasePerSkillLevel;
        }

        public DefaultValues increasePerSkillLevel(double increasePerSkillLevel) {
            this.increasePerSkillLevel = increasePerSkillLevel;
            return this;
        }

        public double increasePerBuildingLevel() {
            return this.increasePerBuildingLevel;
        }

        public DefaultValues increasePerBuildingLevel(double increasePerBuildingLevel) {
            this.increasePerBuildingLevel = increasePerBuildingLevel;
            return this;
        }
    }
}

