/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.item.ItemHandlerHelper2;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuSwitchingMessage;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public abstract class TeachRecipeScreen<MENU extends TeachRecipeMenu<RECIPE>, RECIPE>
extends AbstractContainerScreen<MENU> {
    public static final Component TEXT_DONE = Component.m_237115_((String)"gui.done");
    public static final ResourceLocation SWITCH_TEXTURE = new ResourceLocation("minecolonies", "textures/gui/craftingswitch.png");
    public static final int SWITCH_WIDTH = 20;
    public static final int SWITCH_HEIGHT = 18;
    public static final int SWITCH_X_OFFSET = 148;
    public static final int SWITCH_Y_OFFSET = 34;
    private Button doneButton;
    private ImageButton switchButton;
    private Component lastError;

    public TeachRecipeScreen(MENU menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.doneButton = Button.m_253074_((Component)TEXT_DONE, this::onDoneButtonPress).m_252987_(this.f_97735_ + 1, this.f_97736_ + this.f_97727_ + 4, 150, 20).m_253136_();
        this.doneButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.doneButton);
        this.switchButton = new ImageButton(this.f_97735_ + this.getSwitchButtonX(), this.f_97736_ + this.getSwitchButtonY(), 20, 18, 0, 0, 19, SWITCH_TEXTURE, btn -> MineColoniesCompatibility.network().sendToServer((AbstractMessage)new TeachRecipeMenuSwitchingMessage()));
        this.switchButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.switchButton);
    }

    public int getSwitchButtonX() {
        return 148;
    }

    public int getSwitchButtonY() {
        return 34;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.lastError != null) {
            int x = this.doneButton.m_252754_() + (this.doneButton.m_5711_() - this.f_96541_.f_91062_.m_92852_((FormattedText)this.lastError)) / 2;
            int y = this.doneButton.m_252907_() + this.doneButton.m_93694_() + 2;
            graphics.m_280614_(this.f_96541_.f_91062_, this.lastError, x, y, -65536, true);
        }
        this.switchButton.f_93624_ = !ModuleManager.POLYMORPH.isLoaded() && ((TeachRecipeMenu)this.f_97732_).getRecipes().size() >= 2;
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.m_280218_(this.getTexture(), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public abstract ResourceLocation getTexture();

    protected void m_181908_() {
        super.m_181908_();
        Component error = this.getError();
        this.doneButton.f_93623_ = error == null;
        this.lastError = error;
    }

    protected Component getError() {
        Object recipe = ((TeachRecipeMenu)this.f_97732_).getRecipe();
        if (recipe == null) {
            return TeachRecipeMenu.TEXT_RECIPE_NOT_FOUND;
        }
        return ((TeachRecipeMenu)this.f_97732_).getCurrentError();
    }

    private void onDoneButtonPress(Button button) {
        if (this.getError() != null) {
            return;
        }
        Object recipe = ((TeachRecipeMenu)this.f_97732_).getRecipe();
        if (recipe != null) {
            List<ItemStorage> input = ItemHandlerHelper2.unwrap((IItemHandler)new InvWrapper((Container)((TeachRecipeMenu)this.f_97732_).getInputContainer()), true).stream().map(stack -> {
                int amount = stack.m_41613_();
                stack = stack.m_41777_();
                stack.m_41764_(1);
                ItemStorage storage = new ItemStorage(stack);
                storage.setAmount(amount);
                return storage;
            }).toList();
            this.onDone(recipe, input);
        }
    }

    protected abstract void onDone(RECIPE var1, List<ItemStorage> var2);
}

