/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.building.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;

public class NetworkStorageViewRegistry {
    private static final List<NetworkStorageViewProvider> REGISTRY = new ArrayList<NetworkStorageViewProvider>();

    public static void register(@NotNull NetworkStorageViewProvider provider) {
        REGISTRY.add(provider);
    }

    @Nullable
    public static INetworkStorageView select(@NotNull BlockEntity blockEntity, @Nullable Direction direction) {
        return REGISTRY.stream().map(provider -> provider.getNetworkStorageView(blockEntity, direction)).filter(view -> view != null && view.getDirection() == direction).findFirst().orElse(null);
    }

    public static List<NetworkStorageViewProvider> getRegistry() {
        return Collections.unmodifiableList(REGISTRY);
    }

    private NetworkStorageViewRegistry() {
    }

    public static interface NetworkStorageViewProvider {
        @Nullable
        public INetworkStorageView getNetworkStorageView(@NotNull BlockEntity var1, @Nullable Direction var2);
    }
}

