/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.item;

import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.client.GunItemStackRenderer;
import com.mrcrayfish.guns.client.KeyBinds;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.common.NetworkGunManager;
import com.mrcrayfish.guns.debug.Debug;
import com.mrcrayfish.guns.enchantment.EnchantmentTypes;
import com.mrcrayfish.guns.item.IColored;
import com.mrcrayfish.guns.item.IMeta;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public class GunItem
extends Item
implements IColored,
IMeta {
    private WeakHashMap<CompoundTag, Gun> modifiedGunCache = new WeakHashMap();
    private Gun gun = new Gun();

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public void setGun(NetworkGunManager.Supplier supplier) {
        this.gun = supplier.getGun();
    }

    public Gun getGun() {
        return this.gun;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add((Component)Component.m_237110_((String)"info.cgm.ammo_type", (Object[])new Object[]{Component.m_237115_((String)ammo.m_5524_()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        }
        Object additionalDamageText = "";
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
            float additionalDamage = tagCompound.m_128457_("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                additionalDamageText = String.valueOf(ChatFormatting.GREEN) + " +" + ItemStack.f_41584_.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = String.valueOf(ChatFormatting.RED) + " " + ItemStack.f_41584_.format(additionalDamage);
            }
        }
        float damage = modifiedGun.getProjectile().getDamage();
        damage = GunModifierHelper.getModifiedProjectileDamage(stack, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(stack, damage);
        tooltip.add((Component)Component.m_237110_((String)"info.cgm.damage", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(damage) + (String)additionalDamageText}).m_130940_(ChatFormatting.GRAY));
        if (tagCompound != null) {
            if (tagCompound.m_128471_("IgnoreAmmo")) {
                tooltip.add((Component)Component.m_237115_((String)"info.cgm.ignore_ammo").m_130940_(ChatFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.m_128451_("AmmoCount");
                tooltip.add((Component)Component.m_237110_((String)"info.cgm.ammo", (Object[])new Object[]{ChatFormatting.WHITE.toString() + ammoCount + "/" + GunEnchantmentHelper.getAmmoCapacity(stack, modifiedGun)}).m_130940_(ChatFormatting.GRAY));
            }
        }
        tooltip.add((Component)Component.m_237110_((String)"info.cgm.attachment_help", (Object[])new Object[]{KeyBinds.KEY_ATTACHMENTS.m_90863_().getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        Gun modifiedGun = this.getModifiedGun(stack);
        return !tagCompound.m_128471_("IgnoreAmmo") && tagCompound.m_128451_("AmmoCount") != GunEnchantmentHelper.getAmmoCapacity(stack, modifiedGun);
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        Gun modifiedGun = this.getModifiedGun(stack);
        return (int)(13.0 * ((double)tagCompound.m_128451_("AmmoCount") / (double)GunEnchantmentHelper.getAmmoCapacity(stack, modifiedGun)));
    }

    public int m_142159_(ItemStack stack) {
        return Objects.requireNonNull(ChatFormatting.YELLOW.m_126665_());
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    return Gun.create(tagCompound.m_128469_("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Gun"));
                return gunCopy;
            });
        }
        if (GunMod.isDebugging()) {
            return Debug.getGun(this);
        }
        return this.gun;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentTypes.SEMI_AUTO_GUN) {
            Gun modifiedGun = this.getModifiedGun(stack);
            return !modifiedGun.getGeneral().isAuto();
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getMaxStackSize(stack) == 1;
    }

    public int m_6473_() {
        return 5;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new GunItemStackRenderer();
            }
        });
    }
}

