/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.compat;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.common.AmmoContext;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.compat.CuriosHelper;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.remote.player.EnderBackpackItem;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.NonNullConsumer;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class L2BackpackHelper {
    private static final Map<Predicate<ItemStack>, SearchResult> search = ImmutableMap.of(s -> s.m_41720_() instanceof BaseBagItem, (p, s, i) -> L2BackpackHelper.handleBaseBagItem(s, i), s -> s.m_41720_() instanceof EnderBackpackItem, (p, s, i) -> L2BackpackHelper.handleEnderBackpackItem(p, i), s -> s.m_41720_() instanceof WorldChestItem, L2BackpackHelper::handleWorldChest);

    public static AmmoContext findAmmo(Player player, ResourceLocation id) {
        for (Map.Entry<Predicate<ItemStack>, SearchResult> entry : search.entrySet()) {
            AmmoContext searched = L2BackpackHelper.searchFor(player, id, entry.getKey(), entry.getValue());
            if (searched.equals(AmmoContext.NONE)) continue;
            return searched;
        }
        return AmmoContext.NONE;
    }

    private static AmmoContext searchFor(Player player, ResourceLocation id, Predicate<ItemStack> filter, SearchResult result) {
        AtomicReference<AmmoContext> ctx = new AtomicReference<AmmoContext>(AmmoContext.NONE);
        if (GunMod.curiosLoaded) {
            CuriosHelper.runOnCurios(player, (NonNullConsumer<? super ICuriosItemHandler>)((NonNullConsumer)h -> h.findFirstCurio(filter).ifPresent(r -> ctx.set(result.get(player, r.stack(), id)))));
        }
        if (!ctx.get().equals(AmmoContext.NONE)) {
            return ctx.get();
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (filter.test(chest)) {
            ctx.set(result.get(player, chest, id));
        }
        return ctx.get();
    }

    private static AmmoContext handleBaseBagItem(ItemStack bagStack, ResourceLocation id) {
        if (!(bagStack.m_41720_() instanceof BaseBagItem)) {
            return AmmoContext.NONE;
        }
        List inv = BaseBagItem.getItems((ItemStack)bagStack);
        if (inv.isEmpty()) {
            return AmmoContext.NONE;
        }
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (!Gun.isAmmo(stack, id)) continue;
            return new AmmoContext(stack, s -> BaseBagItem.setItems((ItemStack)bagStack, (List)inv));
        }
        return AmmoContext.NONE;
    }

    private static AmmoContext handleEnderBackpackItem(Player player, ResourceLocation id) {
        PlayerEnderChestContainer ender = player.m_36327_();
        for (int i = 0; i < ender.m_6643_(); ++i) {
            ItemStack stack = ender.m_8020_(i);
            if (!Gun.isAmmo(stack, id)) continue;
            return new AmmoContext(stack, (Container)ender);
        }
        return AmmoContext.NONE;
    }

    private static AmmoContext handleWorldChest(Player player, ItemStack chestStack, ResourceLocation id) {
        Item item = chestStack.m_41720_();
        if (!(item instanceof WorldChestItem)) {
            return AmmoContext.NONE;
        }
        WorldChestItem w = (WorldChestItem)item;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return AmmoContext.NONE;
        }
        ServerLevel l = (ServerLevel)level;
        AtomicReference<AmmoContext> atomic = new AtomicReference<AmmoContext>(AmmoContext.NONE);
        w.getContainer(chestStack, l).ifPresent(c -> {
            SimpleContainer container = c.container;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!Gun.isAmmo(stack, id)) continue;
                atomic.set(new AmmoContext(stack, (Container)container));
            }
        });
        return atomic.get();
    }

    static interface SearchResult {
        public AmmoContext get(Player var1, ItemStack var2, ResourceLocation var3);
    }
}

