/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ElevatorContactBlockEntity
extends SmartBlockEntity {
    public DoorControlBehaviour doorControls;
    public ElevatorColumn.ColumnCoords columnCoords;
    public boolean activateBlock;
    public String shortName = "";
    public String longName = "";
    public String lastReportedCurrentFloor = "";
    private int yTargetFromNBT = Integer.MIN_VALUE;
    private boolean deferNameGenerator = false;

    public ElevatorContactBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.doorControls = new DoorControlBehaviour(this);
        behaviours.add(this.doorControls);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128359_("ShortName", this.shortName);
        tag.m_128359_("LongName", this.longName);
        if (this.lastReportedCurrentFloor != null) {
            tag.m_128359_("LastReportedCurrentFloor", this.lastReportedCurrentFloor);
        }
        if (clientPacket) {
            return;
        }
        tag.m_128379_("Activate", this.activateBlock);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)this.f_58857_, this.columnCoords);
        if (column == null) {
            return;
        }
        tag.m_128405_("ColumnTarget", column.getTargetedYLevel());
        if (column.isActive()) {
            NBTHelper.putMarker((CompoundTag)tag, (String)"ColumnActive");
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.shortName = tag.m_128461_("ShortName");
        this.longName = tag.m_128461_("LongName");
        if (tag.m_128441_("LastReportedCurrentFloor")) {
            this.lastReportedCurrentFloor = tag.m_128461_("LastReportedCurrentFloor");
        }
        if (clientPacket) {
            return;
        }
        this.activateBlock = tag.m_128471_("Activate");
        if (!tag.m_128441_("ColumnTarget")) {
            return;
        }
        int target = tag.m_128451_("ColumnTarget");
        boolean active = tag.m_128441_("ColumnActive");
        if (this.columnCoords == null) {
            this.yTargetFromNBT = target;
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((LevelAccessor)this.f_58857_, this.columnCoords);
        column.target(target);
        column.setActive(active);
    }

    public void updateDisplayedFloor(String floor) {
        if (floor.equals(this.lastReportedCurrentFloor)) {
            return;
        }
        this.lastReportedCurrentFloor = floor;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, this.f_58858_);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.columnCoords = ElevatorContactBlock.getColumnCoords((LevelAccessor)this.f_58857_, this.f_58858_);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((LevelAccessor)this.f_58857_, this.columnCoords);
        column.add(this.f_58858_);
        if (this.shortName.isBlank()) {
            this.deferNameGenerator = true;
        }
        if (this.yTargetFromNBT == Integer.MIN_VALUE) {
            return;
        }
        column.target(this.yTargetFromNBT);
        this.yTargetFromNBT = Integer.MIN_VALUE;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.deferNameGenerator) {
            return;
        }
        if (this.columnCoords != null) {
            ElevatorColumn.getOrCreate((LevelAccessor)this.f_58857_, this.columnCoords).initNames(this.f_58857_);
        }
        this.deferNameGenerator = false;
    }

    @Override
    public void invalidate() {
        ElevatorColumn column;
        if (this.columnCoords != null && (column = ElevatorColumn.get((LevelAccessor)this.f_58857_, this.columnCoords)) != null) {
            column.remove(this.f_58858_);
        }
        super.invalidate();
    }

    public void updateName(String shortName, String longName) {
        this.shortName = shortName;
        this.longName = longName;
        this.deferNameGenerator = false;
        this.notifyUpdate();
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)this.f_58857_, this.columnCoords);
        if (column != null) {
            column.namesChanged();
        }
    }

    public Couple<String> getNames() {
        return Couple.create((Object)this.shortName, (Object)this.longName);
    }
}

