/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;

public record MaterialStatsWrapper(IMaterial material) {
    private static final IMaterialRegistry REGISTRY = MaterialRegistry.getInstance();

    public MaterialId getMaterialId() {
        return this.material.getIdentifier().getId();
    }

    public List<ItemStack> getInputs() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return Collections.emptyList();
        }
        MaterialVariantId variantId = MaterialVariantId.parse((String)this.material.getIdentifier().toString());
        List<ItemStack> repairStacks = RecipeHelper.getUIRecipes((RecipeManager)world.m_7465_(), (RecipeType)((RecipeType)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class, recipe -> variantId.matchesVariant(recipe.getMaterial())).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().m_43908_())).toList();
        if (repairStacks.isEmpty()) {
            repairStacks = Collections.singletonList(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(variantId));
        }
        return repairStacks;
    }

    public FluidStack getFluidStack() {
        return MaterialCastingLookup.getCastingFluids((MaterialVariantId)this.material.getIdentifier()).stream().flatMap(recipe -> recipe.getFluids().stream()).findFirst().orElse(FluidStack.EMPTY);
    }

    public <T extends IMaterialStats> Optional<T> getStats(MaterialStatsId materialStatsId) {
        return REGISTRY.getMaterialStats(this.getMaterialId(), materialStatsId);
    }

    public boolean hasStats(List<MaterialStatsId> statsIds) {
        return statsIds.stream().anyMatch(stat -> this.getStats((MaterialStatsId)stat).isPresent());
    }

    public List<ModifierEntry> getTraits(MaterialStatsId materialStatsId) {
        return REGISTRY.getTraits(this.material.getIdentifier().getId(), materialStatsId);
    }
}

