/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import java.util.List;
import java.util.Optional;
import me.paypur.tconjei.ColorProvider;
import me.paypur.tconjei.jei.AbstractMaterialStatsCategory;
import me.paypur.tconjei.jei.MaterialStatsWrapper;
import me.paypur.tconjei.jei.TConJEIPlugin;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class ArmorStatsCategory
extends AbstractMaterialStatsCategory {
    public ArmorStatsCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.icon = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/jei.png"), 32, 0, 16, 16);
        this.title = Component.m_237115_((String)"tconjei.tool_stats.armor");
        this.recipeType = TConJEIPlugin.ARMOR_STATS;
        this.statsIds = List.of(PlatingMaterialStats.HELMET.getId(), PlatingMaterialStats.CHESTPLATE.getId(), PlatingMaterialStats.LEGGINGS.getId(), PlatingMaterialStats.BOOTS.getId(), PlatingMaterialStats.SHIELD.getId(), StatlessMaterialStats.SHIELD_CORE.getIdentifier(), StatlessMaterialStats.MAILLE.getIdentifier());
        this.tag = TinkerTags.Items.ARMOR;
    }

    @Override
    public void draw(MaterialStatsWrapper wrapper, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        float lineNumber;
        int tier = wrapper.material().getTier();
        int color = MaterialTooltipCache.getColor((MaterialVariantId)wrapper.getMaterialId()).m_131265_();
        float f = lineNumber = 0.0f;
        lineNumber = f + 1.0f;
        this.drawComponentShadowCentered(gui, (Component)Component.m_237115_((String)Util.makeTranslationKey((String)"material", (ResourceLocation)wrapper.getMaterialId())).m_130940_(ChatFormatting.UNDERLINE), f, color);
        float f2 = lineNumber;
        lineNumber = f2 + 1.0f;
        this.drawComponentShadowCentered(gui, (Component)Component.m_237110_((String)"tconjei.tooltip.tier", (Object[])new Object[]{tier}), f2, ColorProvider.getTierColor(tier).orElse(color));
        List<IMaterialStats> statsList = this.statsIds.stream().map(wrapper::getStats).filter(Optional::isPresent).map(Optional::get).toList();
        List<PlatingMaterialStats> platingList = statsList.stream().filter(stats -> stats instanceof PlatingMaterialStats).map(stats -> (PlatingMaterialStats)stats).toList();
        List<StatlessMaterialStats> statlessList = statsList.stream().filter(stats -> stats instanceof StatlessMaterialStats).map(stats -> (StatlessMaterialStats)stats).toList();
        if (!platingList.isEmpty()) {
            IMaterialStats stat = (IMaterialStats)platingList.get(0);
            List<ModifierEntry> traits = wrapper.getTraits(stat.getIdentifier());
            this.drawTraits(gui, traits, lineNumber);
            this.drawComponent(gui, (Component)Component.m_237115_((String)"stat.tconstruct.plating").m_130940_(ChatFormatting.UNDERLINE), 0, lineNumber, color, true);
            lineNumber += (float)Math.max(traits.size(), 1);
            if (stat.getType() == PlatingMaterialStats.SHIELD) {
                for (Component line : stat.getLocalizedInfo()) {
                    float f3 = lineNumber;
                    lineNumber = f3 + 1.0f;
                    this.drawStatComponent(gui, line, f3);
                }
            } else {
                String durabilityText = ((Component)stat.getLocalizedInfo().get(0)).m_6879_().getString();
                String armorText = ((Component)stat.getLocalizedInfo().get(1)).m_6879_().getString();
                durabilityText = durabilityText.substring(0, durabilityText.length() - 2);
                armorText = armorText.substring(0, armorText.length() - 2);
                List<ArmorStat> armorStats = platingList.stream().map(plating -> new ArmorStat((Component)plating.getLocalizedName(), plating.durability(), plating.armor())).toList();
                int maxTextWidth = armorStats.stream().map(s -> FONT.m_92895_(s.text)).max(Integer::compareTo).get();
                int maxArmorWidth = Math.max(armorStats.stream().map(s -> FONT.m_92895_(s.armor)).max(Integer::compareTo).get(), FONT.m_92895_(armorText));
                int maxDurabilityWidth = Math.max(armorStats.stream().map(s -> FONT.m_92895_(s.durability)).max(Integer::compareTo).get(), FONT.m_92895_(durabilityText));
                int space = FONT.m_92895_(" ");
                this.drawString(gui, durabilityText, maxTextWidth, lineNumber, ColorProvider.TEXT, false);
                float f4 = lineNumber;
                lineNumber = f4 + 1.0f;
                this.drawString(gui, armorText, maxTextWidth + maxDurabilityWidth + space, f4, ColorProvider.TEXT, false);
                for (ArmorStat armorStat : armorStats) {
                    int x = maxTextWidth + maxDurabilityWidth - FONT.m_92895_(armorStat.durability);
                    int x1 = maxTextWidth + maxDurabilityWidth + space + maxArmorWidth - FONT.m_92895_(armorStat.armor);
                    this.drawString(gui, armorStat.text, 0, lineNumber, ColorProvider.TEXT, false);
                    this.drawString(gui, armorStat.durability, x, lineNumber, ColorProvider.DURABILITY, true);
                    float f5 = lineNumber;
                    lineNumber = f5 + 1.0f;
                    this.drawString(gui, armorStat.armor, x1, f5, ColorProvider.ARMOR, true);
                }
                float f6 = lineNumber;
                lineNumber = f6 + 1.0f;
                this.drawStatComponent(gui, (Component)stat.getLocalizedInfo().get(2), f6);
                float f7 = lineNumber;
                lineNumber = f7 + 1.0f;
                this.drawStatComponent(gui, (Component)stat.getLocalizedInfo().get(3), f7);
            }
            lineNumber += 0.5f;
        }
        for (StatlessMaterialStats statless : statlessList) {
            float f8 = lineNumber;
            lineNumber = f8 + 1.0f;
            this.drawComponent(gui, (Component)statless.getLocalizedName().m_130940_(ChatFormatting.UNDERLINE), 0, f8, color, true);
            for (Component line : statless.getLocalizedInfo()) {
                float f9 = lineNumber;
                lineNumber = f9 + 1.0f;
                this.drawStatComponent(gui, line, f9);
            }
            lineNumber += 0.5f;
        }
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltips, MaterialStatsWrapper wrapper, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        block8: {
            if (this.addMaterialTooltip(tooltips, wrapper, mouseX, mouseY)) {
                return;
            }
            float lineNumber = 2.0f;
            List<IMaterialStats> statsList = this.statsIds.stream().map(wrapper::getStats).filter(Optional::isPresent).map(Optional::get).toList();
            List<IMaterialStats> platingList = statsList.stream().filter(stats -> stats instanceof PlatingMaterialStats).toList();
            if (platingList.isEmpty()) break block8;
            IMaterialStats stat = platingList.get(0);
            if (stat.getType() == PlatingMaterialStats.SHIELD) {
                for (int i = 0; i < stat.getLocalizedDescriptions().size(); ++i) {
                    float f = lineNumber;
                    lineNumber = f + 1.0f;
                    if (!this.addStatTooltip(tooltips, stat, i, mouseX, mouseY, f)) continue;
                    return;
                }
            } else {
                List<ModifierEntry> traits = wrapper.getTraits(stat.getIdentifier());
                if (this.addTraitTooltip(tooltips, traits, mouseX, mouseY, lineNumber)) {
                    return;
                }
                int maxTextWidth = statsList.stream().map(s -> FONT.m_92895_(s.getLocalizedName().m_6879_().getString().split(" ")[0] + ": ")).max(Integer::compareTo).get();
                String durabilityText = ((Component)stat.getLocalizedInfo().get(0)).m_6879_().getString();
                durabilityText = durabilityText.substring(0, durabilityText.length() - 2);
                if (this.addStatTooltip(tooltips, stat, 0, maxTextWidth, mouseX, mouseY, lineNumber += (float)Math.max(traits.size(), 1))) {
                    return;
                }
                float f = lineNumber;
                lineNumber = f + 1.0f;
                if (this.addStatTooltip(tooltips, stat, 1, maxTextWidth + FONT.m_92895_(durabilityText), mouseX, mouseY, f)) {
                    return;
                }
                lineNumber += (float)platingList.size();
                for (int i = 2; i < stat.getLocalizedDescriptions().size(); ++i) {
                    float f2 = lineNumber;
                    lineNumber = f2 + 1.0f;
                    if (!this.addStatTooltip(tooltips, stat, i, mouseX, mouseY, f2)) continue;
                    return;
                }
            }
        }
    }

    private record ArmorStat(String text, String durability, String armor) {
        private ArmorStat(Component text, int durability, float armor) {
            this(text.m_6879_().getString().split(" ")[0] + ": ", String.valueOf(durability), armor + " ");
        }
    }
}

