/*
 * Decompiled with CFR 0.152.
 */
package darkorg.sereneseasonsphc2trees.event;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;

@Mod.EventBusSubscriber(modid="sereneseasonsphc2trees", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.DEDICATED_SERVER})
public class ForgeServerEvents {
    @SubscribeEvent
    public static void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        BlockPos pos = event.getPos();
        Level level = (Level)event.getLevel();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
        boolean isFertile = ModFertility.isCropFertile((String)(key != null ? key.toString() : null), (Level)level, (BlockPos)pos);
        if (ModConfig.fertility.seasonalCrops && !isFertile && !ForgeServerEvents.isGlassAboveBlock(level, pos)) {
            if (ModConfig.fertility.outOfSeasonCropBehavior == 0 && level.m_213780_().m_188503_(6) != 0) {
                event.setResult(Event.Result.DENY);
            }
            if (ModConfig.fertility.outOfSeasonCropBehavior == 1) {
                event.setResult(Event.Result.DENY);
            }
            if (ModConfig.fertility.outOfSeasonCropBehavior == 2) {
                if (!state.m_204336_(ModTags.Blocks.UNBREAKABLE_INFERTILE_CROPS)) {
                    event.setResult(Event.Result.DENY);
                    event.getLevel().m_46961_(pos, false);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private static boolean isGlassAboveBlock(Level world, BlockPos cropPos) {
        for (int i = 0; i < 16; ++i) {
            if (!world.m_8055_(cropPos.m_7918_(0, i + 1, 0)).m_204336_(ModTags.Blocks.GREENHOUSE_GLASS)) continue;
            return true;
        }
        return false;
    }
}

