/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import romelo333.notenoughwands.keys.KeyBindings;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.wands.WandUsage;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.setup.Registration;
import romelo333.notenoughwands.varia.ClientTools;
import romelo333.notenoughwands.varia.IEnergyItem;
import romelo333.notenoughwands.varia.ItemCapabilityProvider;
import romelo333.notenoughwands.varia.Tools;

public class GenericWand
extends Item
implements IEnergyItem {
    protected float usageFactor = 1.0f;

    public GenericWand() {
        super(Registration.createStandardProperties().setNoRepair().m_41487_(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemCapabilityProvider(stack, this);
    }

    public static double checkPickup(Player player, Level world, BlockPos pos, BlockState state, double maxHardness) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f || (double)hardness > maxHardness) {
            Tools.error(player, "This block is to hard to take!");
            return -1.0;
        }
        if (!state.canEntityDestroy((BlockGetter)world, pos, (Entity)player)) {
            Tools.error(player, "You are not allowed to take this block!");
            return -1.0;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot take it!");
            return -1.0;
        }
        double cost = BuildingWandsConfiguration.getBlockCost(state);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to take this block");
            return -1.0;
        }
        return cost;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.needsPower()) {
            tooltip.add((Component)ComponentFactory.literal((String)("Energy: " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack))).m_130940_(ChatFormatting.GREEN));
        }
    }

    public boolean m_142522_(ItemStack pStack) {
        if (this.needsPower() && ((Boolean)WandsConfiguration.showDurabilityBarForRF.get()).booleanValue()) {
            return true;
        }
        return super.m_142522_(pStack);
    }

    public GenericWand usageFactor(float usageFactor) {
        this.usageFactor = usageFactor;
        return this;
    }

    protected boolean checkUsage(ItemStack wandStack, Player player, float difficultyScale) {
        if (player.m_7500_()) {
            return true;
        }
        if (this.needsXP()) {
            int needsxp = this.calculateXP();
            int experience = Tools.getPlayerXP(player) - (int)((float)needsxp * difficultyScale);
            if (experience <= 0) {
                Tools.error(player, "Not enough experience!");
                return false;
            }
        }
        if (this.needsDamage() && wandStack.m_41773_() >= wandStack.m_41776_()) {
            Tools.error(player, "This wand can no longer be used!");
            return false;
        }
        if (this.needsPower()) {
            int needsrf = this.calculatePower();
            if (this.getEnergyStored(wandStack) < (int)((float)needsrf * difficultyScale)) {
                Tools.error(player, "Not enough energy to use this wand!");
                return false;
            }
        }
        return true;
    }

    public boolean m_41465_() {
        return this.needsDamage();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.calculateMaxDamage();
    }

    protected void registerUsage(ItemStack stack, Player player, float difficultyScale) {
        if (player.m_7500_()) {
            return;
        }
        if (this.needsXP()) {
            Tools.addPlayerXP(player, -((int)((float)this.calculateXP() * difficultyScale)));
        }
        if (this.needsDamage()) {
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> {});
        }
        if (this.needsPower()) {
            this.extractEnergy(stack, (int)((float)this.calculatePower() * difficultyScale), false);
        }
    }

    public void toggleMode(Player player, ItemStack stack) {
    }

    public void toggleSubMode(Player player, ItemStack stack) {
    }

    public void renderOverlay(RenderLevelStageEvent evt, Player player, ItemStack wand) {
    }

    protected static void renderOutlines(RenderLevelStageEvent evt, Player p, Set<BlockPos> coordinates, int r, int g, int b) {
        PoseStack matrixStack = evt.getPoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        ClientTools.renderOutlines(matrixStack, buffer, coordinates, r, g, b);
    }

    protected void showModeKeyDescription(List<Component> list, String suffix) {
        String keyDescription = KeyBindings.wandModifier != null ? KeyBindings.wandModifier.m_90860_() : "unknown";
        list.add((Component)ComponentFactory.literal((String)("Mode key (" + keyDescription + ") to " + suffix)).m_130940_(ChatFormatting.YELLOW));
    }

    protected void showSubModeKeyDescription(List<Component> list, String suffix) {
        String keyDescription = KeyBindings.wandSubMode != null ? KeyBindings.wandSubMode.m_90860_() : "unknown";
        list.add((Component)ComponentFactory.literal((String)("Sub-mode key (" + keyDescription + ") to " + suffix)).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!this.needsPower()) {
            return 0;
        }
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0;
        }
        int energy = container.m_41783_().m_128451_("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.calculatePower(), maxExtract));
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!this.needsPower()) {
            return 0;
        }
        container.m_41784_();
        int energy = container.m_41783_().m_128451_("Energy");
        int maxrf = this.calculateMaxPower();
        int energyReceived = Math.min(maxrf - energy, Math.min(maxrf, maxReceive));
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0;
        }
        return container.m_41783_().m_128451_("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.calculateMaxPower();
    }

    private int calculatePower() {
        return (int)(500.0f * this.usageFactor);
    }

    private int calculateMaxPower() {
        return (int)(100000.0f * this.usageFactor);
    }

    private int calculateMaxDamage() {
        return (int)(200.0f / this.usageFactor);
    }

    private int calculateXP() {
        return (int)(10.0f * this.usageFactor);
    }

    private boolean needsPower() {
        return WandsConfiguration.cachedWandUsage.needsPower();
    }

    private boolean needsDamage() {
        return WandsConfiguration.cachedWandUsage == WandUsage.DURABILITY;
    }

    private boolean needsXP() {
        return WandsConfiguration.cachedWandUsage == WandUsage.XP;
    }
}

