/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class CapturingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public CapturingWand() {
        this.usageFactor(3.0f);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        EntityType entityType;
        String type;
        super.m_7373_(stack, worldIn, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128441_("mob") && !(type = tagCompound.m_128461_("type")).isEmpty() && (entityType = mcjty.lib.varia.Tools.getEntity((ResourceLocation)new ResourceLocation(type))) != null) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Captured mob: ")).m_7220_(entityType.m_20676_()));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        ItemStack stack = player.m_21120_(hand);
        BlockPos pos = context.m_8083_();
        if (!world.f_46443_) {
            CompoundTag tagCompound = stack.m_41784_();
            if (tagCompound.m_128441_("mob")) {
                Tag mobCompound = tagCompound.m_128423_("mob");
                String type = tagCompound.m_128461_("type");
                LivingEntity entityLivingBase = this.createEntity(player, world, type);
                if (entityLivingBase == null) {
                    Tools.error(player, "Something went wrong trying to spawn creature!");
                    return InteractionResult.FAIL;
                }
                entityLivingBase.m_20258_((CompoundTag)mobCompound);
                entityLivingBase.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                tagCompound.m_128473_("mob");
                tagCompound.m_128473_("type");
                world.m_7967_((Entity)entityLivingBase);
            } else {
                Tools.error(player, "There is no mob captured in this wand!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    private LivingEntity createEntity(Player player, Level world, String type) {
        EntityType entityType = mcjty.lib.varia.Tools.getEntity((ResourceLocation)new ResourceLocation(type));
        if (entityType != null) {
            return (LivingEntity)entityType.m_20615_(world);
        }
        return null;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.m_20193_().f_46443_) {
            if (entity instanceof LivingEntity) {
                LivingEntity entityLivingBase = (LivingEntity)entity;
                if (stack.m_41784_().m_128441_("mob")) {
                    Tools.error(player, "There is already a mob in this wand!");
                    return true;
                }
                if (entityLivingBase instanceof Player) {
                    Tools.error(player, "I don't think that player would appreciate being captured!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.allowHostile.get()).booleanValue() && entityLivingBase instanceof Enemy) {
                    Tools.error(player, "It is not possible to capture hostile mobs with this wand!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.allowPassive.get()).booleanValue() && !(entityLivingBase instanceof Enemy)) {
                    Tools.error(player, "It is not possible to capture passive mobs with this wand!");
                    return true;
                }
                double cost = WandsConfiguration.getEntityCost(entity);
                if (cost <= (double)0.001f) {
                    Tools.error(player, "It is illegal to take this entity");
                    return true;
                }
                float difficultyScale = (float)((double)entityLivingBase.m_21233_() * cost * (Double)WandsConfiguration.difficultyMult.get() + (Double)WandsConfiguration.difficultyAdd.get());
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                CompoundTag tagCompound = new CompoundTag();
                entityLivingBase.m_7380_(tagCompound);
                stack.m_41784_().m_128365_("mob", (Tag)tagCompound);
                stack.m_41784_().m_128359_("type", mcjty.lib.varia.Tools.getId((EntityType)entity.m_6095_()).toString());
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

