/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import romelo333.notenoughwands.modules.protectionwand.ProtectionWandConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class ProtectedBlocks
extends AbstractWorldData<ProtectedBlocks> {
    private static final String NAME = "NEWProtectedBlocks";
    private Map<GlobalPos, Integer> blocks = new HashMap<GlobalPos, Integer>();
    private Map<Pair<ResourceKey<Level>, ChunkPos>, Set<BlockPos>> perDimPerChunkCache = new HashMap<Pair<ResourceKey<Level>, ChunkPos>, Set<BlockPos>>();
    private Map<Integer, Integer> counter = new HashMap<Integer, Integer>();
    private int lastId = 1;
    public static ResourceKey<Level> clientSideWorld = null;
    public static Map<ChunkPos, Set<BlockPos>> clientSideProtectedBlocks = new HashMap<ChunkPos, Set<BlockPos>>();

    public ProtectedBlocks() {
    }

    public ProtectedBlocks(CompoundTag tag) {
        this.lastId = tag.m_128451_("lastId");
        this.blocks.clear();
        this.perDimPerChunkCache.clear();
        this.counter.clear();
        ListTag list = tag.m_128437_("blocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tc = list.m_128728_(i);
            String dim = tc.m_128461_("dim");
            GlobalPos block = GlobalPos.m_122643_((ResourceKey)LevelTools.getId((ResourceLocation)new ResourceLocation(dim)), (BlockPos)new BlockPos(tc.m_128451_("x"), tc.m_128451_("y"), tc.m_128451_("z")));
            int id = tc.m_128451_("id");
            this.blocks.put(block, id);
            this.incrementProtection(id);
        }
    }

    public static ProtectedBlocks getProtectedBlocks(Level world) {
        return (ProtectedBlocks)ProtectedBlocks.getData((Level)world, ProtectedBlocks::new, ProtectedBlocks::new, (String)NAME);
    }

    public static boolean isProtectedClientSide(Level world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!clientSideProtectedBlocks.containsKey(chunkPos)) {
            return false;
        }
        Set<BlockPos> positions = clientSideProtectedBlocks.get(chunkPos);
        return positions.contains(pos);
    }

    public int getNewId() {
        ++this.lastId;
        this.save();
        return this.lastId - 1;
    }

    private void decrementProtection(Integer oldId) {
        int cnt = this.counter.containsKey(oldId) ? this.counter.get(oldId) : 0;
        this.counter.put(oldId, --cnt);
    }

    private void incrementProtection(Integer newId) {
        int cnt = this.counter.containsKey(newId) ? this.counter.get(newId) : 0;
        this.counter.put(newId, ++cnt);
    }

    public int getProtectedBlockCount(int id) {
        return this.counter.containsKey(id) ? this.counter.get(id) : 0;
    }

    private int getMaxProtectedBlocks(int id) {
        if (id == -1) {
            return 0;
        }
        return (Integer)ProtectionWandConfiguration.maximumProtectedBlocks.get();
    }

    public boolean protect(Player player, Level world, BlockPos pos, int id) {
        int max;
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos);
        if (id != -1 && this.blocks.containsKey(key)) {
            Tools.error(player, "This block is already protected!");
            return false;
        }
        if (this.blocks.containsKey(key)) {
            this.decrementProtection(this.blocks.get(key));
        }
        if ((max = this.getMaxProtectedBlocks(id)) != 0 && this.getProtectedBlockCount(id) >= max) {
            Tools.error(player, "Maximum number of protected blocks reached!");
            return false;
        }
        this.blocks.put(key, id);
        this.clearCache(key);
        this.incrementProtection(id);
        this.save();
        return true;
    }

    public boolean unprotect(Player player, Level world, BlockPos pos, int id) {
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos);
        if (!this.blocks.containsKey(key)) {
            Tools.error(player, "This block is not protected!");
            return false;
        }
        if (id != -1 && this.blocks.get(key) != id) {
            Tools.error(player, "You have no permission to unprotect this block!");
            return false;
        }
        this.decrementProtection(this.blocks.get(key));
        this.blocks.remove(key);
        this.clearCache(key);
        this.save();
        return true;
    }

    public int clearProtections(Level world, int id) {
        HashSet<GlobalPos> toRemove = new HashSet<GlobalPos>();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            if (entry.getValue() != id) continue;
            toRemove.add(entry.getKey());
        }
        int cnt = 0;
        for (GlobalPos coordinate : toRemove) {
            ++cnt;
            this.blocks.remove(coordinate);
            this.clearCache(coordinate);
        }
        this.counter.put(id, 0);
        this.save();
        return cnt;
    }

    public boolean isProtected(Level world, BlockPos pos) {
        return this.blocks.containsKey(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
    }

    public boolean hasProtections() {
        return !this.blocks.isEmpty();
    }

    public void fetchProtectedBlocks(Set<BlockPos> coordinates, Level world, int x, int y, int z, float radius, int id) {
        radius *= radius;
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            BlockPos c;
            float sqdist;
            GlobalPos block;
            if (entry.getValue() != id && (id != -2 || entry.getValue() == -1) || !(block = entry.getKey()).m_122640_().equals((Object)world.m_46472_()) || !((sqdist = (float)((x - (c = block.m_122646_()).m_123341_()) * (x - c.m_123341_()) + (y - c.m_123342_()) * (y - c.m_123342_()) + (z - c.m_123343_()) * (z - c.m_123343_()))) < radius)) continue;
            coordinates.add(c);
        }
    }

    private void clearCache(GlobalPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos.m_122646_());
        this.perDimPerChunkCache.remove(Pair.of((Object)pos.m_122640_(), (Object)chunkpos));
    }

    public Map<ChunkPos, Set<BlockPos>> fetchProtectedBlocks(Level world, BlockPos pos) {
        HashMap<ChunkPos, Set<BlockPos>> result = new HashMap<ChunkPos, Set<BlockPos>>();
        ChunkPos chunkpos = new ChunkPos(pos);
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_ - 1, chunkpos.f_45579_ - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_, chunkpos.f_45579_ - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_ + 1, chunkpos.f_45579_ - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_ - 1, chunkpos.f_45579_));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_, chunkpos.f_45579_));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_ + 1, chunkpos.f_45579_));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_ - 1, chunkpos.f_45579_ + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_, chunkpos.f_45579_ + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.f_45578_ + 1, chunkpos.f_45579_ + 1));
        return result;
    }

    public void fetchProtectedBlocks(Map<ChunkPos, Set<BlockPos>> allresults, Level world, ChunkPos chunkpos) {
        Pair key = Pair.of((Object)world.m_46472_(), (Object)chunkpos);
        if (this.perDimPerChunkCache.containsKey(key)) {
            allresults.put(chunkpos, this.perDimPerChunkCache.get(key));
            return;
        }
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            ChunkPos bc;
            GlobalPos block = entry.getKey();
            if (!block.m_122640_().equals((Object)world.m_46472_()) || !(bc = new ChunkPos(block.m_122646_())).equals((Object)chunkpos)) continue;
            result.add(block.m_122646_());
        }
        allresults.put(chunkpos, result);
        this.perDimPerChunkCache.put((Pair<ResourceKey<Level>, ChunkPos>)key, result);
    }

    public CompoundTag m_7176_(CompoundTag tagCompound) {
        tagCompound.m_128405_("lastId", this.lastId);
        ListTag list = new ListTag();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            GlobalPos block = entry.getKey();
            CompoundTag tc = new CompoundTag();
            tc.m_128405_("x", block.m_122646_().m_123341_());
            tc.m_128405_("y", block.m_122646_().m_123342_());
            tc.m_128405_("z", block.m_122646_().m_123343_());
            tc.m_128359_("dim", block.m_122640_().m_135782_().toString());
            tc.m_128405_("id", entry.getValue().intValue());
            list.add((Object)tc);
        }
        tagCompound.m_128365_("blocks", (Tag)list);
        return tagCompound;
    }
}

