/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.SoundTools;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class BuildingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_9 = 0;
    public static final int MODE_9ROW = 1;
    public static final int MODE_25 = 2;
    public static final int MODE_25ROW = 3;
    public static final int MODE_SINGLE = 4;
    public static final int MODE_LAST = 4;
    public static final String[] DESCRIPTIONS = new String[]{"9 blocks", "9 blocks row", "25 blocks", "25 blocks row", "single"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"undo", stack -> this.countUndoStates((ItemStack)stack) > 0, stack -> Integer.toString(this.countUndoStates((ItemStack)stack))), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)]), TooltipBuilder.parameter((String)"submode", stack -> this.getSubMode((ItemStack)stack) == 1, stack -> this.getSubMode((ItemStack)stack) == 1 ? "Rotated" : "")});
    public static final int[] amount = new int[]{9, 9, 25, 25, 1};

    public BuildingWand() {
        this.usageFactor(1.0f);
    }

    private int countUndoStates(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41783_();
            return (compound.m_128441_("undo1") ? 1 : 0) + (compound.m_128441_("undo2") ? 1 : 0);
        }
        return 0;
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flags) {
        super.m_7373_(itemStack, world, list, flags);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), itemStack, list, flags);
        this.showModeKeyDescription(list, "switch mode");
        this.showSubModeKeyDescription(list, "change orientation");
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 4) {
            mode = 0;
        }
        Tools.notify(player, Component.m_237113_((String)("Switched to " + DESCRIPTIONS[mode] + " mode")));
        stack.m_41784_().m_128405_("mode", mode);
    }

    @Override
    public void toggleSubMode(Player player, ItemStack stack) {
        int submode = this.getSubMode(stack);
        submode = submode == 1 ? 0 : 1;
        Tools.notify(player, Component.m_237113_((String)"Switched orientation"));
        stack.m_41784_().m_128405_("submode", submode);
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_("mode");
    }

    private int getSubMode(ItemStack stack) {
        return stack.m_41784_().m_128451_("submode");
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        ItemStack wandStack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                this.undoPlaceBlock(wandStack, player, world, pos);
            } else {
                this.placeBlock(wandStack, player, world, pos, side);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void placeBlock(ItemStack wandStack, Player player, Level world, BlockPos pos, Direction side) {
        if (!this.checkUsage(wandStack, player, 1.0f)) {
            return;
        }
        boolean notenough = false;
        BlockState blockState = world.m_8055_(pos);
        Set<BlockPos> coordinates = this.findSuitableBlocks(wandStack, world, side, pos, blockState);
        HashSet<BlockPos> undo = new HashSet<BlockPos>();
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(wandStack, player, 1.0f)) break;
            BlockHitResult result = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, coordinate, false);
            ItemStack pickBlock = blockState.getCloneItemStack((HitResult)result, (BlockGetter)world, coordinate, player);
            ItemStack consumed = Tools.consumeInventoryItem(pickBlock, player.m_150109_(), player);
            if (!consumed.m_41619_()) {
                SoundTools.playSound((Level)world, (SoundEvent)blockState.m_60827_().m_56776_(), (double)coordinate.m_123341_(), (double)coordinate.m_123342_(), (double)coordinate.m_123343_(), (double)1.0, (double)1.0);
                BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)coordinate);
                Tools.placeStackAt(player, consumed, world, coordinate, null);
                if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                    blocksnapshot.restore(true, false);
                    if (!player.m_7500_()) {
                        Tools.giveItem(player, consumed);
                    }
                }
                player.f_36096_.m_38946_();
                this.registerUsage(wandStack, player, 1.0f);
                undo.add(coordinate);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
        this.registerUndo(wandStack, blockState, world, undo);
    }

    private void registerUndo(ItemStack stack, BlockState state, Level world, Set<BlockPos> undo) {
        CompoundTag undoTag = new CompoundTag();
        undoTag.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)state));
        undoTag.m_128359_("dimension", world.m_46472_().m_135782_().toString());
        int[] undoX = new int[undo.size()];
        int[] undoY = new int[undo.size()];
        int[] undoZ = new int[undo.size()];
        int idx = 0;
        for (BlockPos coordinate : undo) {
            undoX[idx] = coordinate.m_123341_();
            undoY[idx] = coordinate.m_123342_();
            undoZ[idx] = coordinate.m_123343_();
            ++idx;
        }
        undoTag.m_128385_("x", undoX);
        undoTag.m_128385_("y", undoY);
        undoTag.m_128385_("z", undoZ);
        CompoundTag wandTag = stack.m_41784_();
        if (wandTag.m_128441_("undo1")) {
            wandTag.m_128365_("undo2", wandTag.m_128423_("undo1"));
        }
        wandTag.m_128365_("undo1", (Tag)undoTag);
    }

    private void undoPlaceBlock(ItemStack stack, Player player, Level world, BlockPos pos) {
        CompoundTag wandTag = stack.m_41784_();
        CompoundTag undoTag1 = (CompoundTag)wandTag.m_128423_("undo1");
        CompoundTag undoTag2 = (CompoundTag)wandTag.m_128423_("undo2");
        Set<BlockPos> undo1 = this.checkUndo(player, world, undoTag1);
        Set<BlockPos> undo2 = this.checkUndo(player, world, undoTag2);
        if (undo1 == null && undo2 == null) {
            Tools.error(player, "Nothing to undo!");
            return;
        }
        if (undo1 != null && undo1.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag1, undo1);
            if (wandTag.m_128441_("undo2")) {
                wandTag.m_128365_("undo1", wandTag.m_128423_("undo2"));
                wandTag.m_128473_("undo2");
            } else {
                wandTag.m_128473_("undo1");
            }
            return;
        }
        if (undo2 != null && undo2.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag2, undo2);
            wandTag.m_128473_("undo2");
            return;
        }
        Tools.error(player, "Select at least one block of the area you want to undo!");
    }

    private void performUndo(ItemStack stack, Player player, Level world, BlockPos pos, CompoundTag undoTag, Set<BlockPos> undo) {
        BlockState state = NBTTools.readBlockState((Level)world, (CompoundTag)undoTag.m_128469_("block"));
        int cnt = 0;
        for (BlockPos coordinate : undo) {
            BlockState testState = world.m_8055_(coordinate);
            if (testState != state) continue;
            SoundTools.playSound((Level)world, (SoundEvent)state.m_60827_().m_56776_(), (double)coordinate.m_123341_(), (double)coordinate.m_123342_(), (double)coordinate.m_123343_(), (double)1.0, (double)1.0);
            BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)coordinate);
            world.m_46597_(coordinate, Blocks.f_50016_.m_49966_());
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                blocksnapshot.restore(true, false);
                continue;
            }
            ++cnt;
        }
        if (cnt > 0 && !player.m_7500_()) {
            BlockHitResult result = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, pos, false);
            ItemStack itemStack = state.getCloneItemStack((HitResult)result, (BlockGetter)world, pos, player);
            itemStack.m_41764_(cnt);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemStack);
            player.f_36096_.m_38946_();
        }
    }

    private Set<BlockPos> checkUndo(Player player, Level world, CompoundTag undoTag) {
        if (undoTag == null) {
            return null;
        }
        String dimension = undoTag.m_128461_("dimension");
        ResourceKey dim = LevelTools.getId((ResourceLocation)new ResourceLocation(dimension));
        if (!Objects.equals(dim, world.m_46472_())) {
            Tools.error(player, "Select at least one block of the area you want to undo!");
            return null;
        }
        int[] undoX = undoTag.m_128465_("x");
        int[] undoY = undoTag.m_128465_("y");
        int[] undoZ = undoTag.m_128465_("z");
        HashSet<BlockPos> undo = new HashSet<BlockPos>();
        for (int i = 0; i < undoX.length; ++i) {
            undo.add(new BlockPos(undoX[i], undoY[i], undoZ[i]));
        }
        return undo;
    }

    @Override
    public void renderOverlay(RenderLevelStageEvent evt, Player player, ItemStack wand) {
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        if (!(mouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult btrace = (BlockHitResult)mouseOver;
        if (btrace.m_82434_() != null && btrace.m_82425_() != null) {
            Level world = player.m_20193_();
            BlockPos blockPos = btrace.m_82425_();
            if (blockPos == null) {
                return;
            }
            BlockState blockState = world.m_8055_(blockPos);
            Block block = blockState.m_60734_();
            if (block != null && !blockState.m_60795_()) {
                if (player.m_6144_()) {
                    CompoundTag wandTag = wand.m_41784_();
                    CompoundTag undoTag1 = (CompoundTag)wandTag.m_128423_("undo1");
                    CompoundTag undoTag2 = (CompoundTag)wandTag.m_128423_("undo2");
                    Set<BlockPos> undo1 = this.checkUndo(player, world, undoTag1);
                    Set<BlockPos> undo2 = this.checkUndo(player, world, undoTag2);
                    if (undo1 == null && undo2 == null) {
                        return;
                    }
                    if (undo1 != null && undo1.contains(blockPos)) {
                        Set<BlockPos> coordinates = undo1;
                        BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                    } else if (undo2 != null && undo2.contains(blockPos)) {
                        Set<BlockPos> coordinates = undo2;
                        BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                    }
                } else {
                    Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, btrace.m_82434_(), blockPos, blockState);
                    BuildingWand.renderOutlines(evt, player, coordinates, 50, 250, 180);
                }
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, Level world, Direction sideHit, BlockPos pos, BlockState state) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.addLast(pos);
        this.findSuitableBlocks(world, coordinates, done, todo, sideHit, state, amount[this.getMode(stack)], this.getMode(stack) == 1 || this.getMode(stack) == 3, this.getSubMode(stack));
        return coordinates;
    }

    private void findSuitableBlocks(Level world, Set<BlockPos> coordinates, Set<BlockPos> done, Deque<BlockPos> todo, Direction direction, BlockState state, int maxAmount, boolean rowMode, int rotated) {
        BlockPos offset;
        BlockPos base;
        Direction dirA = null;
        Direction dirB = null;
        if (rowMode) {
            base = todo.getFirst();
            offset = base.m_121945_(direction);
            dirA = rotated == 1 ? this.dir2(direction) : this.dir1(direction);
            dirB = dirA.m_122424_();
            if (!this.isSuitable(world, state, base.m_121945_(dirA), offset.m_121945_(dirA)) || !this.isSuitable(world, state, base.m_121945_(dirB), offset.m_121945_(dirB))) {
                dirA = rotated == 1 ? this.dir3(direction) : this.dir2(direction);
                dirB = dirA.m_122424_();
                if (!this.isSuitable(world, state, base.m_121945_(dirA), offset.m_121945_(dirA)) || !this.isSuitable(world, state, base.m_121945_(dirB), offset.m_121945_(dirB))) {
                    dirA = rotated == 1 ? this.dir1(direction) : this.dir3(direction);
                    dirB = dirA.m_122424_();
                }
            }
        }
        while (!todo.isEmpty() && coordinates.size() < maxAmount) {
            base = todo.pollFirst();
            if (done.contains(base)) continue;
            done.add(base);
            offset = base.m_121945_(direction);
            if (!this.isSuitable(world, state, base, offset)) continue;
            coordinates.add(offset);
            if (rowMode) {
                todo.addLast(base.m_121945_(dirA));
                todo.addLast(base.m_121945_(dirB));
                continue;
            }
            todo.addLast(base.m_121945_(this.dir1(direction)));
            todo.addLast(base.m_121945_(this.dir1(direction).m_122424_()));
            todo.addLast(base.m_121945_(this.dir2(direction)));
            todo.addLast(base.m_121945_(this.dir2(direction).m_122424_()));
            todo.addLast(base.m_121945_(this.dir1(direction)).m_121945_(this.dir2(direction)));
            todo.addLast(base.m_121945_(this.dir1(direction)).m_121945_(this.dir2(direction).m_122424_()));
            todo.addLast(base.m_121945_(this.dir1(direction).m_122424_()).m_121945_(this.dir2(direction)));
            todo.addLast(base.m_121945_(this.dir1(direction).m_122424_()).m_121945_(this.dir2(direction).m_122424_()));
        }
    }

    private boolean isSuitable(Level world, BlockState state, BlockPos base, BlockPos offset) {
        BlockState destState = world.m_8055_(offset);
        BlockState baseState = world.m_8055_(base);
        return baseState == state && destState.m_247087_();
    }

    private Direction dir1(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> Direction.EAST;
            case Direction.NORTH, Direction.SOUTH -> Direction.EAST;
            case Direction.WEST, Direction.EAST -> Direction.DOWN;
        };
    }

    private Direction dir2(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> Direction.SOUTH;
            case Direction.NORTH, Direction.SOUTH -> Direction.DOWN;
            case Direction.WEST, Direction.EAST -> Direction.SOUTH;
        };
    }

    private Direction dir3(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> Direction.SOUTH;
            case Direction.NORTH, Direction.SOUTH -> Direction.WEST;
            case Direction.WEST, Direction.EAST -> Direction.SOUTH;
        };
    }
}

