/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.forge;

import com.mojang.logging.LogUtils;
import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.forge.block.ForgeCompactBarrelBlock;
import com.witchica.compactstorage.forge.block.ForgeCompactChestBlock;
import com.witchica.compactstorage.forge.block.ForgeDrumBlock;
import com.witchica.compactstorage.forge.block.entity.ForgeCompactBarrelBlockEntity;
import com.witchica.compactstorage.forge.block.entity.ForgeCompactChestBlockEntity;
import com.witchica.compactstorage.forge.block.entity.ForgeDrumBlockEntity;
import com.witchica.compactstorage.forge.item.ForgeBackpackItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="compact_storage")
public class CompactStorageForge {
    private static final Logger LOGGER;
    private static final DeferredRegister<Block> BLOCKS;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES;
    private static final DeferredRegister<MenuType<?>> MENU_TYPES;
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static ResourceLocation COMPACT_CHEST_GENERIC_IDENTIFIER;
    public static ResourceLocation COMPACT_BARREL_GENERIC_IDENTIFIER;
    public static final RegistryObject<ForgeCompactChestBlock>[] COMPACT_CHEST_BLOCKS;
    public static final RegistryObject<ForgeCompactBarrelBlock>[] COMPACT_BARREL_BLOCKS;
    public static final RegistryObject<ForgeDrumBlock>[] DRUM_BLOCKS;
    public static final RegistryObject<ForgeBackpackItem>[] BACKPACK_ITEMS;
    public static final List<RegistryObject<ForgeCompactChestBlock>> ALL_CHEST_BLOCKS;
    public static final List<RegistryObject<ForgeCompactBarrelBlock>> ALL_BARREL_BLOCKS;
    public static final String COMPACT_CHEST_TRANSLATION_KEY;
    public static RegistryObject<BlockEntityType<ForgeCompactBarrelBlockEntity>> COMPACT_BARREL_ENTITY_TYPE;
    public static RegistryObject<BlockEntityType<ForgeCompactChestBlockEntity>> COMPACT_CHEST_ENTITY_TYPE;
    public static RegistryObject<BlockEntityType<ForgeDrumBlockEntity>> DRUM_ENTITY_TYPE;
    public static final HashMap<DyeColor, RegistryObject<ForgeCompactChestBlock>> DYE_COLOR_TO_COMPACT_CHEST_MAP;
    public static final HashMap<DyeColor, RegistryObject<ForgeCompactBarrelBlock>> DYE_COLOR_TO_COMPACT_BARREL_MAP;
    public static final HashMap<DyeColor, RegistryObject<ForgeBackpackItem>> DYE_COLOR_TO_BACKPACK_MAP;
    public static final RegistryObject<StorageUpgradeItem> UPGRADE_ROW_ITEM;
    public static final RegistryObject<StorageUpgradeItem> UPGRADE_COLUMN_ITEM;
    public static final RegistryObject<StorageUpgradeItem> UPGRADE_RETAINING_ITEM;
    public static final RegistryObject<ForgeCompactChestBlock>[] WOODEN_COMPACT_CHEST_BLOCKS;
    public static final RegistryObject<ForgeCompactBarrelBlock>[] WOODEN_COMPACT_BARREL_BLOCKS;
    public static final RegistryObject<MenuType<CompactChestScreenHandler>> COMPACT_CHEST_SCREEN_HANDLER;
    public static final RegistryObject<CreativeModeTab> COMPACT_STORAGE_TAB;
    public static final RegistryObject<CreativeModeTab> COMPACT_STORAGE_WOOD_TAB;

    public CompactStorageForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        BLOCK_ENTITY_TYPES.register(eventBus);
        MENU_TYPES.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
    }

    static {
        int i;
        LOGGER = LogUtils.getLogger();
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"compact_storage");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"compact_storage");
        BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"compact_storage");
        MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"compact_storage");
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"compact_storage");
        COMPACT_CHEST_GENERIC_IDENTIFIER = new ResourceLocation("compact_storage", "compact_chest");
        COMPACT_BARREL_GENERIC_IDENTIFIER = new ResourceLocation("compact_storage", "compact_barrel");
        COMPACT_CHEST_BLOCKS = new RegistryObject[16];
        COMPACT_BARREL_BLOCKS = new RegistryObject[16];
        DRUM_BLOCKS = new RegistryObject[CompactStorageUtil.DRUM_TYPES.length];
        BACKPACK_ITEMS = new RegistryObject[16];
        ALL_CHEST_BLOCKS = new ArrayList<RegistryObject<ForgeCompactChestBlock>>();
        ALL_BARREL_BLOCKS = new ArrayList<RegistryObject<ForgeCompactBarrelBlock>>();
        COMPACT_CHEST_TRANSLATION_KEY = Util.m_137492_((String)"container", (ResourceLocation)COMPACT_CHEST_GENERIC_IDENTIFIER);
        COMPACT_BARREL_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("compact_barrel", () -> BlockEntityType.Builder.m_155273_(ForgeCompactBarrelBlockEntity::new, (Block[])((Block[])ALL_BARREL_BLOCKS.stream().map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
        COMPACT_CHEST_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("compact_chest", () -> BlockEntityType.Builder.m_155273_(ForgeCompactChestBlockEntity::new, (Block[])((Block[])ALL_CHEST_BLOCKS.stream().map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
        DRUM_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("drum", () -> BlockEntityType.Builder.m_155273_(ForgeDrumBlockEntity::new, (Block[])((Block[])Arrays.stream(DRUM_BLOCKS).map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
        DYE_COLOR_TO_COMPACT_CHEST_MAP = new HashMap();
        DYE_COLOR_TO_COMPACT_BARREL_MAP = new HashMap();
        DYE_COLOR_TO_BACKPACK_MAP = new HashMap();
        UPGRADE_ROW_ITEM = ITEMS.register("upgrade_row", () -> new StorageUpgradeItem(new Item.Properties()));
        UPGRADE_COLUMN_ITEM = ITEMS.register("upgrade_column", () -> new StorageUpgradeItem(new Item.Properties()));
        UPGRADE_RETAINING_ITEM = ITEMS.register("upgrade_retainer", () -> new StorageUpgradeItem(new Item.Properties()));
        WOODEN_COMPACT_CHEST_BLOCKS = new RegistryObject[CompactStorageUtil.DRUM_TYPES.length];
        WOODEN_COMPACT_BARREL_BLOCKS = new RegistryObject[CompactStorageUtil.DRUM_TYPES.length];
        COMPACT_CHEST_SCREEN_HANDLER = MENU_TYPES.register("compact_chest", () -> IForgeMenuType.create(CompactChestScreenHandler::new));
        COMPACT_STORAGE_TAB = CREATIVE_MODE_TABS.register("compact_storage_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.compact_storage.general")).m_257737_(() -> new ItemStack((ItemLike)COMPACT_CHEST_BLOCKS[0].get(), 1)).m_257501_((params, populator) -> {
            Arrays.stream(COMPACT_CHEST_BLOCKS).forEach(item -> populator.m_246326_((ItemLike)item.get()));
            Arrays.stream(COMPACT_BARREL_BLOCKS).forEach(item -> populator.m_246326_((ItemLike)item.get()));
            Arrays.stream(BACKPACK_ITEMS).forEach(item -> populator.m_246326_((ItemLike)item.get()));
            populator.m_246326_((ItemLike)UPGRADE_COLUMN_ITEM.get());
            populator.m_246326_((ItemLike)UPGRADE_ROW_ITEM.get());
            populator.m_246326_((ItemLike)UPGRADE_RETAINING_ITEM.get());
        }).m_257652_());
        COMPACT_STORAGE_WOOD_TAB = CREATIVE_MODE_TABS.register("compact_storage_wood_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.compact_storage.wood")).m_257737_(() -> new ItemStack((ItemLike)WOODEN_COMPACT_CHEST_BLOCKS[0].get(), 1)).m_257501_((params, populator) -> {
            Arrays.stream(WOODEN_COMPACT_CHEST_BLOCKS).forEach(item -> populator.m_246326_((ItemLike)item.get()));
            Arrays.stream(WOODEN_COMPACT_BARREL_BLOCKS).forEach(item -> populator.m_246326_((ItemLike)item.get()));
            Arrays.stream(DRUM_BLOCKS).forEach(item -> populator.m_246326_((ItemLike)item.get()));
        }).m_257652_());
        for (i = 0; i < 16; ++i) {
            String dyeName = DyeColor.m_41053_((int)i).m_41065_().toLowerCase(Locale.ROOT);
            DyeColor color = DyeColor.m_41053_((int)i);
            int id = i;
            CompactStorageForge.COMPACT_CHEST_BLOCKS[i] = BLOCKS.register("compact_chest_" + dyeName, () -> new ForgeCompactChestBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_).m_60955_().m_60913_(2.0f, 5.0f)));
            ALL_CHEST_BLOCKS.add(COMPACT_CHEST_BLOCKS[i]);
            ITEMS.register("compact_chest_" + dyeName, () -> new BlockItem((Block)COMPACT_CHEST_BLOCKS[id].get(), new Item.Properties()));
            DYE_COLOR_TO_COMPACT_CHEST_MAP.put(color, COMPACT_CHEST_BLOCKS[i]);
            CompactStorageForge.BACKPACK_ITEMS[i] = ITEMS.register("backpack_" + dyeName, () -> new ForgeBackpackItem(new Item.Properties().m_41487_(1)));
            DYE_COLOR_TO_BACKPACK_MAP.put(color, BACKPACK_ITEMS[i]);
            CompactStorageForge.COMPACT_BARREL_BLOCKS[i] = BLOCKS.register("compact_barrel_" + color, () -> new ForgeCompactBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60913_(2.0f, 5.0f)));
            DYE_COLOR_TO_COMPACT_BARREL_MAP.put(color, COMPACT_BARREL_BLOCKS[i]);
            ALL_BARREL_BLOCKS.add(COMPACT_BARREL_BLOCKS[i]);
            ITEMS.register("compact_barrel_" + dyeName, () -> new BlockItem((Block)COMPACT_BARREL_BLOCKS[id].get(), new Item.Properties()));
        }
        for (i = 0; i < CompactStorageUtil.DRUM_TYPES.length; ++i) {
            int id = i;
            CompactStorageForge.DRUM_BLOCKS[id] = BLOCKS.register(CompactStorageUtil.DRUM_TYPES[id] + "_drum", () -> new ForgeDrumBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60913_(2.0f, 2.0f)));
            ITEMS.register(CompactStorageUtil.DRUM_TYPES[i] + "_drum", () -> new BlockItem((Block)DRUM_BLOCKS[id].get(), new Item.Properties()));
            CompactStorageForge.WOODEN_COMPACT_CHEST_BLOCKS[i] = BLOCKS.register(CompactStorageUtil.DRUM_TYPES[id] + "_compact_chest", () -> new ForgeCompactChestBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_)));
            ITEMS.register(CompactStorageUtil.DRUM_TYPES[id] + "_compact_chest", () -> new BlockItem((Block)WOODEN_COMPACT_CHEST_BLOCKS[id].get(), new Item.Properties()));
            CompactStorageForge.WOODEN_COMPACT_BARREL_BLOCKS[i] = BLOCKS.register(CompactStorageUtil.DRUM_TYPES[id] + "_compact_barrel", () -> new ForgeCompactBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_)));
            ITEMS.register(CompactStorageUtil.DRUM_TYPES[id] + "_compact_barrel", () -> new BlockItem((Block)WOODEN_COMPACT_BARREL_BLOCKS[id].get(), new Item.Properties()));
            ALL_CHEST_BLOCKS.add(WOODEN_COMPACT_CHEST_BLOCKS[id]);
            ALL_BARREL_BLOCKS.add(WOODEN_COMPACT_BARREL_BLOCKS[id]);
        }
    }
}

