/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.block.CompactChestBlock;
import com.witchica.compactstorage.common.block.entity.CompactChestBlockEntity;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompactChestBlockEntityRenderer
implements BlockEntityRenderer<CompactChestBlockEntity> {
    private final ModelPart chestBase;
    private final ModelPart chestLid;
    private final ModelPart chestLock;
    public static final Map<Block, ResourceLocation> CHEST_TEXTURES;
    public static final ResourceLocation RETAINING_TEXTURE;

    public CompactChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart modelPart = ctx.m_173582_(ModelLayers.f_171275_);
        this.chestBase = modelPart.m_171324_("bottom");
        this.chestLid = modelPart.m_171324_("lid");
        this.chestLock = modelPart.m_171324_("lock");
    }

    public void render(CompactChestBlockEntity compactChestBlockEntity, float delta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        Level world = compactChestBlockEntity.m_58904_();
        boolean bl = world != null;
        BlockState blockState = bl ? compactChestBlockEntity.m_58900_() : (BlockState)CompactStoragePlatform.getCompactChestBlock(0).m_49966_().m_61124_((Property)CompactChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockState.m_60734_();
        matrixStack.m_85836_();
        float y_rotation = ((Direction)blockState.m_61143_((Property)CompactChestBlock.FACING)).m_122435_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-y_rotation));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        float lid_openness = compactChestBlockEntity.m_6683_(delta);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110446_((ResourceLocation)CHEST_TEXTURES.get(block)));
        this.chestLock.f_104203_ = this.chestLid.f_104203_ = -(lid_openness * 1.5707964f);
        this.chestBase.m_104301_(matrixStack, vertexConsumer, light, overlay);
        this.chestLid.m_104301_(matrixStack, vertexConsumer, light, overlay);
        VertexConsumer vertexConsumer1 = compactChestBlockEntity.getRetaining() ? vertexConsumerProvider.m_6299_(RenderType.m_110446_((ResourceLocation)RETAINING_TEXTURE)) : vertexConsumer;
        this.chestLock.m_104301_(matrixStack, vertexConsumer, light, overlay);
        matrixStack.m_85849_();
    }

    static {
        int i;
        CHEST_TEXTURES = new HashMap<Block, ResourceLocation>();
        for (i = 0; i < 16; ++i) {
            CHEST_TEXTURES.put(CompactStoragePlatform.getCompactChestBlock(i), new ResourceLocation("compact_storage", String.format("textures/block/chest/%s_chest.png", DyeColor.m_41053_((int)i).name().toLowerCase(Locale.ROOT))));
        }
        for (i = 0; i < CompactStorageUtil.DRUM_TYPES.length; ++i) {
            CHEST_TEXTURES.put(CompactStoragePlatform.getWoodenCompactChestBlock(i), new ResourceLocation("compact_storage", String.format("textures/block/chest/%s_chest.png", CompactStorageUtil.DRUM_TYPES[i])));
        }
        RETAINING_TEXTURE = new ResourceLocation("compact_storage", "textures/block/chest/retaining_chest.png");
    }
}

