/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block.entity;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvironmentInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;

@EnvironmentInterface(itf=LidBlockEntity.class, value=Dist.CLIENT)
public class CompactChestBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider,
CompactStorageInventoryImpl,
LidBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)(this.inventoryWidth * this.inventoryHeight), (Object)ItemStack.f_41583_);
    public int inventoryWidth = 9;
    public int inventoryHeight = 6;
    public int playersUsing = 0;
    public int playersUsingOld = 0;
    public boolean isOpen = false;
    public float lidOpenness = 0.0f;
    public float lastLidOpenness = 0.0f;
    private boolean retaining = false;

    public CompactChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(CompactStoragePlatform.getCompactChestBlockEntityType(), blockPos, blockState);
    }

    public int m_6643_() {
        return this.inventoryWidth * this.inventoryHeight;
    }

    public float m_6683_(float delta) {
        return Mth.m_14179_((float)delta, (float)this.lastLidOpenness, (float)this.lidOpenness);
    }

    protected NonNullList<ItemStack> getInvStackList() {
        return this.inventory;
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.getInvStackList();
    }

    protected void m_6520_(NonNullList<ItemStack> stackList) {
        this.inventory = stackList;
    }

    protected Component m_6820_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new CompactChestScreenHandler(syncId, playerInventory, this.writeToByteBuf());
    }

    @Override
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }

    @Override
    public int getInventoryHeight() {
        return this.inventoryHeight;
    }

    public void m_5856_(Player player) {
        super.m_5856_(player);
        if (!player.m_5833_()) {
            ++this.playersUsing;
        }
    }

    public void m_5785_(Player player) {
        super.m_5785_(player);
        if (!player.m_5833_()) {
            --this.playersUsing;
        }
    }

    public void resizeInventory(boolean copy_contents) {
        NonNullList newInventory = NonNullList.m_122780_((int)(this.inventoryWidth * this.inventoryHeight), (Object)ItemStack.f_41583_);
        if (copy_contents) {
            NonNullList<ItemStack> list = this.inventory;
            for (int i = 0; i < list.size(); ++i) {
                newInventory.set(i, (Object)((ItemStack)list.get(i)));
            }
        }
        this.inventory = newInventory;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventoryWidth = nbt.m_128441_("inventory_width") ? nbt.m_128451_("inventory_width") : 9;
        this.inventoryHeight = nbt.m_128441_("inventory_height") ? nbt.m_128451_("inventory_height") : 3;
        this.retaining = nbt.m_128441_("retaining") && nbt.m_128471_("retaining");
        this.inventory = NonNullList.m_122780_((int)(this.inventoryWidth * this.inventoryHeight), (Object)ItemStack.f_41583_);
        this.readItemsFromTag(this.inventory, nbt);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeItemsToTag(this.inventory, nbt);
        nbt.m_128405_("inventory_width", this.inventoryWidth);
        nbt.m_128405_("inventory_height", this.inventoryHeight);
        nbt.m_128379_("retaining", this.retaining);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CompactChestBlockEntity compactChestBlockEntity) {
        compactChestBlockEntity.lastLidOpenness = compactChestBlockEntity.lidOpenness;
        if (compactChestBlockEntity.playersUsing > 0 && compactChestBlockEntity.playersUsingOld == 0) {
            compactChestBlockEntity.isOpen = true;
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11749_, SoundSource.BLOCKS, 1.0f, 0.9f, true);
        } else if (compactChestBlockEntity.playersUsing == 0 && compactChestBlockEntity.playersUsingOld != 0) {
            compactChestBlockEntity.isOpen = false;
        }
        if (compactChestBlockEntity.playersUsing == 0 && compactChestBlockEntity.lidOpenness >= 0.6f && compactChestBlockEntity.lidOpenness <= 0.7f) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11747_, SoundSource.BLOCKS, 1.0f, 0.9f, true);
        }
        if (compactChestBlockEntity.isOpen && compactChestBlockEntity.lidOpenness < 0.5f) {
            compactChestBlockEntity.lidOpenness = Math.min(compactChestBlockEntity.lidOpenness += 0.25f, 1.0f);
        } else if (compactChestBlockEntity.isOpen && compactChestBlockEntity.lidOpenness < 1.0f) {
            compactChestBlockEntity.lidOpenness = Math.min(compactChestBlockEntity.lidOpenness += 0.1f, 1.0f);
        } else if (!compactChestBlockEntity.isOpen && compactChestBlockEntity.lidOpenness > 0.7f) {
            compactChestBlockEntity.lidOpenness = Math.max(compactChestBlockEntity.lidOpenness - 0.05f, 0.0f);
        } else if (!compactChestBlockEntity.isOpen && compactChestBlockEntity.lidOpenness > 0.0f) {
            compactChestBlockEntity.lidOpenness = Math.max(compactChestBlockEntity.lidOpenness - 0.15f, 0.0f);
        }
        compactChestBlockEntity.playersUsingOld = compactChestBlockEntity.playersUsing;
    }

    public FriendlyByteBuf writeToByteBuf() {
        FriendlyByteBuf packetByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        packetByteBuf.writeInt(0);
        packetByteBuf.m_130064_(this.m_58899_());
        return packetByteBuf;
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player playerEntity) {
        return new CompactChestScreenHandler(syncId, playerInventory, this.writeToByteBuf());
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public boolean increaseSize(int x, int y) {
        if (this.inventoryWidth > 20 && x > 0 || this.inventoryHeight > 11 && y > 0) {
            return false;
        }
        this.inventoryWidth += x;
        this.inventoryHeight += y;
        this.resizeInventory(true);
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 1);
        return true;
    }

    @Override
    public void setRetaining() {
        this.retaining = true;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 1);
    }

    @Override
    public boolean getRetaining() {
        return this.retaining;
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag compoundTag = this.m_187482_();
        if (!this.retaining) {
            compoundTag.m_128473_("Items");
        }
        if (compoundTag.m_128441_("CustomName")) {
            if (!compoundTag.m_128441_("display")) {
                compoundTag.m_128365_("display", (Tag)new CompoundTag());
            }
            compoundTag.m_128469_("display").m_128365_("Name", compoundTag.m_128423_("CustomName"));
            compoundTag.m_128473_("CustomName");
        }
        stack.m_41751_(compoundTag);
    }
}

