/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class CactusClonesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> CHANCE_ON_GROW = ConfigurationProperty.floatProperty((String)"chance_on_grow");
    public static final ConfigurationProperty<CactusBranchBlock.CactusThickness> TRUNK_TYPE = ConfigurationProperty.property((String)"trunk_type", CactusBranchBlock.CactusThickness.class);

    public CactusClonesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_ON_GROW, TRUNK_TYPE});
    }

    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(CHANCE_ON_GROW, (Object)Float.valueOf(0.3f))).with(TRUNK_TYPE, (Object)CactusBranchBlock.CactusThickness.BRANCH);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        return this.tryToPlaceClones(context.levelContext(), context.pos(), context.species(), true, context.bounds());
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        return context.random().m_188501_() < ((Float)configuration.get(CHANCE_ON_GROW)).floatValue() && this.tryToPlaceClones(context.levelContext(), context.pos(), context.species(), false, SafeChunkBounds.ANY);
    }

    private boolean tryToPlaceClones(LevelContext levelContext, BlockPos rootPos, Species species, boolean worldgen, SafeChunkBounds safeBounds) {
        LevelAccessor level = levelContext.accessor();
        if (level == null || this.areCactiAround(level, rootPos.m_7494_(), safeBounds)) {
            return false;
        }
        int clones = 3 + level.m_213780_().m_188503_(5);
        LinkedList<CoordUtils.Surround> validDirs = new LinkedList<CoordUtils.Surround>(Arrays.asList(CoordUtils.Surround.values()));
        boolean clonePlaced = false;
        for (int i = 0; i < clones; ++i) {
            CoordUtils.Surround selectedDir = (CoordUtils.Surround)validDirs.get(level.m_213780_().m_188503_(validDirs.size()));
            if (this.placeCloneAtLocation(levelContext, rootPos.m_121955_(selectedDir.getOffset()), species, worldgen, safeBounds)) {
                clonePlaced = true;
            }
            validDirs.remove(selectedDir);
        }
        return clonePlaced;
    }

    private boolean areCactiAround(LevelAccessor world, BlockPos rootPos, SafeChunkBounds safeBounds) {
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            for (int i = -1; i <= 1; ++i) {
                BlockPos offsetPos = rootPos.m_121955_(dir.getOffset()).m_6630_(i);
                if (!safeBounds.inBounds(offsetPos, false) || !(world.m_8055_(offsetPos).m_60734_() instanceof BranchBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean placeCloneAtLocation(LevelContext levelContext, BlockPos cloneRootPos, Species species, boolean worldgen, SafeChunkBounds safeBounds) {
        LevelAccessor level = levelContext.accessor();
        for (int i = 1; i >= -1; --i) {
            BlockPos offsetRootPos = cloneRootPos.m_6630_(i);
            if (!safeBounds.inBounds(offsetRootPos, false) || !species.isAcceptableSoil(level.m_8055_(offsetRootPos))) continue;
            if (worldgen) {
                if (level instanceof WorldGenRegion) {
                    species.generate(new GenerationContext(levelContext, species, offsetRootPos, offsetRootPos.m_122032_(), level.m_203495_(offsetRootPos.m_123341_(), offsetRootPos.m_123342_(), offsetRootPos.m_123343_()), CoordUtils.getRandomDir((RandomSource)level.m_213780_()), 2, safeBounds));
                }
            } else if (level instanceof Level) {
                species.transitionToTree((Level)level, offsetRootPos.m_7494_());
            }
            return true;
        }
        return false;
    }
}

