/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.block.mushroom;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.poissondisc.Vec2i;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.UpdatesSurroundNeighbors;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DynamicCapCenterBlock
extends Block
implements TreePart,
UpdatesSurroundNeighbors {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)8);
    public CapProperties f_60439_ = CapProperties.NULL;

    public DynamicCapCenterBlock(CapProperties capProperties, BlockBehaviour.Properties properties) {
        this(properties);
        this.setProperties(capProperties);
        capProperties.setDynamicCapState(this.m_49966_(), true);
    }

    public DynamicCapCenterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public void setProperties(CapProperties properties) {
        this.f_60439_ = properties;
    }

    public CapProperties getProperties(BlockState blockState) {
        return this.f_60439_;
    }

    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return from.getFamily() == this.getFamily(state, level, pos) ? 2 : 0;
    }

    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.f_60439_.getRadiusForConnection(state, level, pos, from, side, fromRadius);
    }

    public int getRadius(BlockState state) {
        return 0;
    }

    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        return signal;
    }

    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.f_60439_.getFamily();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.m_8055_(pos)).getFlammability();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.m_8055_(pos)).getFireSpreadSpeed();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getFlammability(state, level, pos, face) > 0 || face == Direction.UP;
    }

    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return branch.getFamily() == this.getFamily(state, level, pos) ? BranchBlock.setSupport((int)0, (int)2) : 0;
    }

    public TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.OTHER;
    }

    public BlockState getCapBlockStateForPlacement(LevelAccessor level, BlockPos pos, int age, BlockState cap, boolean worldGen) {
        if (cap.m_61138_((Property)AGE)) {
            return (BlockState)cap.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
        }
        return cap;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getProperties(state).getPrimitiveCapItemStack();
    }

    public static int getCapAge(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof DynamicCapCenterBlock) {
            return (Integer)state.m_61143_((Property)AGE);
        }
        return -1;
    }

    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        Species species = signal.getSpecies();
        if (!(species instanceof HugeMushroomSpecies)) {
            return signal;
        }
        HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
        if (signal.step()) {
            BlockState thisState = level.m_8055_(pos);
            int age = thisState.m_61138_((Property)AGE) ? (Integer)thisState.m_61143_((Property)AGE) : 0;
            this.branchOut(level, pos, signal, age);
        }
        return signal;
    }

    public GrowSignal branchOut(Level level, BlockPos pos, GrowSignal signal, int age) {
        Species species = signal.getSpecies();
        if (!(species instanceof HugeMushroomSpecies)) {
            return signal;
        }
        HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
        CapProperties capProperties = species2.getCapProperties();
        if (BranchBlock.isNextToBranch((Level)level, (BlockPos)pos, (Direction)signal.dir.m_122424_())) {
            signal.success = false;
            return signal;
        }
        BlockPos nextPos = pos.m_121945_(signal.dir);
        boolean couldGrow = this.tryGrowCap(level, capProperties, age, signal, nextPos, pos, false);
        if (couldGrow) {
            Family family = species2.getFamily();
            BlockState capCenter = level.m_8055_(pos.m_121955_(signal.dir.m_122436_()));
            int thickness = family.getPrimaryThickness() + (capCenter.m_61138_((Property)AGE) ? (Integer)capCenter.m_61143_((Property)AGE) : 0);
            family.getBranchForPlacement((LevelAccessor)level, (Species)species2, pos).ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, Math.min(thickness, family.getMaxBranchRadius()), null));
            signal.radius = Math.min(thickness + 1, family.getMaxBranchRadius());
        }
        signal.success = couldGrow;
        return signal;
    }

    public boolean isBlockCapCenter(Level level, BlockPos pos) {
        TreePart treePart = TreeHelper.getTreePart((BlockState)level.m_8055_(pos));
        return treePart instanceof DynamicCapCenterBlock;
    }

    public boolean tryGrowCap(Level level, CapProperties capProp, int currentAge, GrowSignal signal, BlockPos pos, BlockPos previousPos, boolean forceAge) {
        Species species = signal.getSpecies();
        if (!(species instanceof HugeMushroomSpecies)) {
            return false;
        }
        HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
        int age = currentAge;
        if (currentAge == 0) {
            age = 1;
        } else if (forceAge || level.m_213780_().m_188501_() < species2.getChanceToAge()) {
            age = Math.min(age + 1, this.f_60439_.getMaxAge(species2));
        }
        if (level.m_46859_(pos)) {
            level.m_7731_(pos, this.getCapBlockStateForPlacement((LevelAccessor)level, pos, age == 0 ? 1 : age, capProp.getDynamicCapState(true), false), 2);
            if (age != currentAge) {
                this.ageBranchUnderCap(level, pos, signal, currentAge);
            }
        } else if (age == currentAge) {
            return false;
        }
        if (this.isBlockCapCenter(level, pos)) {
            this.generateCap(age, level, (HugeMushroomSpecies)signal.getSpecies(), pos, previousPos, currentAge, signal.rootPos);
            return true;
        }
        return false;
    }

    protected void ageBranchUnderCap(Level level, BlockPos pos, GrowSignal signal, int currentAge) {
        Species species = signal.getSpecies();
        Family family = species.getFamily();
        int thickness = Math.min(species.getFamily().getPrimaryThickness() + currentAge, species.getMaxBranchRadius());
        BlockPos branchPos = pos.m_121955_(signal.dir.m_122424_().m_122436_());
        family.getBranchForPlacement((LevelAccessor)level, signal.getSpecies(), branchPos).ifPresent(branch -> branch.setRadius((LevelAccessor)level, branchPos, thickness, null));
        signal.radius = Math.min(thickness + 1, species.getMaxBranchRadius());
    }

    protected void generateCap(int newAge, Level pLevel, HugeMushroomSpecies species, BlockPos newPos, BlockPos currentPos, int currentAge, BlockPos rootPos) {
        DynamicCapBlock capBlock = this.f_60439_.getDynamicCapBlock().orElse(null);
        if (capBlock == null) {
            return;
        }
        if (currentPos != newPos || currentAge != newAge) {
            species.getMushroomShapeKit().clearMushroomCap(new MushroomCapContext((LevelAccessor)pLevel, currentPos, species, currentAge));
        }
        species.getMushroomShapeKit().generateMushroomCap(new MushroomCapContext((LevelAccessor)pLevel, newPos, species, newAge));
    }

    public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
        List<Vec2i> ring = MushroomCapDisc.getPrecomputedRing(radius);
        for (Vec2i vec : ring) {
            BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
            if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos))) continue;
            level.m_7731_(ringPos, Blocks.f_50016_.m_49966_(), 2);
        }
    }

    public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
        List<Vec2i> ring = MushroomCapDisc.getPrecomputedRing(radius);
        int placed = 0;
        int notPlaced = 0;
        for (Vec2i vec : ring) {
            BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
            if (DynamicCapCenterBlock.canCapReplace(level.m_8055_(ringPos))) {
                level.m_7731_(ringPos, this.getStateForAge(this.f_60439_, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7494_()))), 2);
                ++placed;
                continue;
            }
            ++notPlaced;
        }
        return placed >= notPlaced;
    }

    public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
        List<Vec2i> ring = MushroomCapDisc.getPrecomputedRing(radius);
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        for (Vec2i vec : ring) {
            BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
            if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos))) continue;
            positions.add(ringPos);
        }
        return positions;
    }

    public static boolean canCapReplace(BlockState state) {
        return state.m_247087_() || state.m_204336_(DTBlockTags.FOLIAGE) || state.m_204336_(BlockTags.f_13035_);
    }

    @Nonnull
    private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap) {
        boolean[] dirs = new boolean[]{false, !topIsCap, true, true, true, true};
        if (yMoved || age == 1) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                float dot = dir.m_122436_().m_123341_() * centerDirection.x + dir.m_122436_().m_123343_() * centerDirection.z;
                if (!(dot >= 0.0f)) continue;
                dirs[negativeFactor ? dir.m_122424_().ordinal() : dir.ordinal()] = false;
            }
        }
        return properties.getDynamicCapState(age, dirs);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean destroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        this.updateNeighborsSurround(level, pos, DynamicCapBlock.class);
        return destroyed;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_60713_((Block)this) && (Integer)pState.m_61143_((Property)AGE) == 0) {
            return this.f_60439_.getAgeZeroShape();
        }
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }
}

