/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.block.mushroom;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.tree.Resettable;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.LootTableSupplier;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.data.CapCenterStateGenerator;
import com.ferreusveritas.dynamictreesplus.data.CapStateGenerator;
import com.ferreusveritas.dynamictreesplus.data.DTPLootTableHandler;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;

public class CapProperties
extends RegistryEntry<CapProperties>
implements Resettable<CapProperties> {
    public static final Codec<CapProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, CapProperties::new));
    public static final CapProperties NULL = ((CapProperties)new CapProperties(){

        @Override
        public Family getFamily() {
            return Family.NULL_FAMILY;
        }

        @Override
        public BlockState getPrimitiveCap() {
            return Blocks.f_50016_.m_49966_();
        }

        @Override
        public ItemStack getPrimitiveCapItemStack() {
            return ItemStack.f_41583_;
        }

        @Override
        public CapProperties setDynamicCapState(BlockState state, boolean center) {
            return this;
        }

        @Override
        public BlockState getDynamicCapState(boolean center) {
            return Blocks.f_50016_.m_49966_();
        }

        @Override
        public BlockState getDynamicCapState(int distance) {
            return Blocks.f_50016_.m_49966_();
        }

        @Override
        public int getFlammability() {
            return 0;
        }

        @Override
        public int getFireSpreadSpeed() {
            return 0;
        }
    }.setRegistryName(DTTrees.NULL)).setBlockRegistryName(DTTrees.NULL);
    public static final TypedRegistry<CapProperties> REGISTRY = new TypedRegistry(CapProperties.class, (RegistryEntry)NULL, new TypedRegistry.EntryType(CODEC));
    protected BlockState primitiveCap;
    protected Family family;
    protected BlockState[] dynamicMushroomBlockDistanceStates = new BlockState[9];
    protected BlockState dynamicMushroomCenterBlock;
    protected int flammability = 0;
    protected int fireSpreadSpeed = 0;
    protected VoxelShape ageZeroShape = Shapes.m_83144_();
    private ResourceLocation blockRegistryName;
    private ResourceLocation centerBlockRegistryName;
    private Item mushroomItem;
    private final LootTableSupplier blockLootTableSupplier;
    private final LootTableSupplier lootTableSupplier;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, CapProperties>> capStateGenerator = MutableLazyValue.supplied(CapStateGenerator::new);
    protected final MutableLazyValue<Generator<DTBlockStateProvider, CapProperties>> capCenterStateGenerator = MutableLazyValue.supplied(CapCenterStateGenerator::new);
    private boolean generateFaceModels = false;
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    public static final String OUTSIDE_FACE = "outside_face";
    public static final String INSIDE_FACE = "inside_face";
    public static final String FACE = "face";
    public static final String CAP_CENTER_AGE_0_PARENT = "cap_center_age_0_parent";

    private CapProperties() {
        this.blockLootTableSupplier = new LootTableSupplier("null/", DTTrees.NULL);
        this.lootTableSupplier = new LootTableSupplier("null/", DTTrees.NULL);
    }

    public CapProperties(ResourceLocation registryName) {
        this(null, registryName);
    }

    public CapProperties(@Nullable BlockState primitiveCap, ResourceLocation registryName) {
        this.family = Family.NULL_FAMILY;
        this.primitiveCap = primitiveCap != null ? primitiveCap : BlockStates.AIR;
        this.setRegistryName(registryName);
        this.centerBlockRegistryName = ResourceLocationUtils.suffix((ResourceLocation)registryName, (String)this.getCenterBlockRegistryNameSuffix());
        this.blockRegistryName = ResourceLocationUtils.suffix((ResourceLocation)registryName, (String)this.getBlockRegistryNameSuffix());
        this.blockLootTableSupplier = new LootTableSupplier("blocks/", this.blockRegistryName);
        this.lootTableSupplier = new LootTableSupplier("trees/mushroom_caps/", registryName);
    }

    public BlockState getPrimitiveCap() {
        return this.primitiveCap;
    }

    public Optional<Block> getPrimitiveCapBlock() {
        return Optionals.ofBlock(this.primitiveCap == null ? null : this.primitiveCap.m_60734_());
    }

    public void setPrimitiveCap(Block primitiveCap) {
        if (this.primitiveCap == null || primitiveCap != this.primitiveCap.m_60734_()) {
            this.primitiveCap = primitiveCap.m_49966_();
        }
    }

    public ItemStack getPrimitiveCapItemStack() {
        return new ItemStack((ItemLike)Item.f_41373_.get(this.getPrimitiveCap().m_60734_()));
    }

    public Family getFamily() {
        return this.family;
    }

    public CapProperties setFamily(Family family) {
        this.family = family;
        if (family.isFireProof()) {
            this.flammability = 0;
            this.fireSpreadSpeed = 0;
        }
        return this;
    }

    public int getFlammability() {
        return this.flammability;
    }

    public void setFlammability(int flammability) {
        this.flammability = flammability;
    }

    public int getFireSpreadSpeed() {
        return this.fireSpreadSpeed;
    }

    public void setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
    }

    public MapColor getDefaultMapColor() {
        return MapColor.f_283825_;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60978_(0.2f).m_60918_(SoundType.f_56736_);
    }

    public int getMaxAge(HugeMushroomSpecies species) {
        return species.getMushroomShapeKit().getMaxCapAge();
    }

    public void setAgeZeroShape(VoxelShape ageZeroShape) {
        this.ageZeroShape = ageZeroShape;
    }

    public VoxelShape getAgeZeroShape() {
        return this.ageZeroShape;
    }

    public ResourceLocation getBlockRegistryName() {
        return this.blockRegistryName;
    }

    public ResourceLocation getCenterBlockRegistryName() {
        return this.centerBlockRegistryName;
    }

    public CapProperties setBlockRegistryName(ResourceLocation blockRegistryName) {
        this.blockRegistryName = blockRegistryName;
        return this;
    }

    public CapProperties setCenterBlockRegistryName(ResourceLocation blockRegistryName) {
        this.centerBlockRegistryName = blockRegistryName;
        return this;
    }

    protected String getBlockRegistryNameSuffix() {
        return "_cap";
    }

    protected String getCenterBlockRegistryNameSuffix() {
        return "_cap_center";
    }

    public Optional<DynamicCapBlock> getDynamicCapBlock() {
        Block block = this.getDynamicCapState(false).m_60734_();
        return Optional.ofNullable(block instanceof DynamicCapBlock ? (DynamicCapBlock)block : null);
    }

    public Optional<DynamicCapCenterBlock> getDynamicCapCenterBlock() {
        Block block = this.getDynamicCapState(true).m_60734_();
        return Optional.ofNullable(block instanceof DynamicCapCenterBlock ? (DynamicCapCenterBlock)block : null);
    }

    protected DynamicCapBlock createDynamicCap(BlockBehaviour.Properties properties) {
        return new DynamicCapBlock(this, properties);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties);
    }

    public void generateDynamicCapBlocks(BlockBehaviour.Properties properties) {
        RegistryHandler.addBlock((ResourceLocation)this.blockRegistryName, () -> this.createDynamicCap(properties));
        RegistryHandler.addBlock((ResourceLocation)this.centerBlockRegistryName, () -> this.createDynamicCapCenter(properties));
    }

    public CapProperties setDynamicCapState(BlockState state, boolean center) {
        if (center) {
            this.dynamicMushroomCenterBlock = state;
            return this;
        }
        this.dynamicMushroomBlockDistanceStates[0] = Blocks.f_50016_.m_49966_();
        for (int i = 1; i <= 8; ++i) {
            this.dynamicMushroomBlockDistanceStates[i] = (BlockState)state.m_61124_((Property)DynamicCapBlock.DISTANCE, (Comparable)Integer.valueOf(i));
        }
        return this;
    }

    public BlockState getDynamicCapState(boolean center) {
        return this.getDynamicCapState(center, 1);
    }

    public BlockState getDynamicCapState(boolean center, int prop) {
        if (center) {
            return (BlockState)this.dynamicMushroomCenterBlock.m_61124_((Property)DynamicCapCenterBlock.AGE, (Comparable)Integer.valueOf(Math.min(prop, 8)));
        }
        return this.getDynamicCapState(prop);
    }

    public BlockState getDynamicCapState(int distance) {
        return Optional.ofNullable(this.dynamicMushroomBlockDistanceStates[Mth.m_14045_((int)distance, (int)0, (int)8)]).orElse(Blocks.f_50016_.m_49966_());
    }

    public BlockState getDynamicCapState(int distance, boolean[] directions) {
        return DynamicCapBlock.setDirectionValues(this.getDynamicCapState(distance), directions);
    }

    public boolean isPartOfCap(BlockState state) {
        DynamicCapBlock capBlock = this.getDynamicCapBlock().orElse(null);
        DynamicCapCenterBlock capCenterBlock = this.getDynamicCapCenterBlock().orElse(null);
        if (capBlock == null || capCenterBlock == null) {
            return false;
        }
        return state.m_60713_((Block)capBlock) || state.m_60713_((Block)capCenterBlock);
    }

    public ParticleOptions sporeParticleType(BlockState state, Level level, BlockPos pos, RandomSource random) {
        return ParticleTypes.f_123790_;
    }

    public Vec3 sporeParticleSpeed(BlockState state, Level level, BlockPos pos, RandomSource random) {
        return new Vec3(1.0, 0.0, 1.0);
    }

    public final Item getMushroomItem() {
        if (this.mushroomItem == null) {
            LogManager.getLogger().warn("Invoked too early or item was not set on \"" + String.valueOf(this.getRegistryName()) + "\".");
            return Items.f_41852_;
        }
        return this.mushroomItem;
    }

    public void setMushroomItem(Item mushroomItem) {
        this.mushroomItem = mushroomItem;
    }

    public ResourceLocation getBlockLootTableName() {
        return this.blockLootTableSupplier.getName();
    }

    public boolean shouldGenerateBlockDrops() {
        return this.shouldGenerateDrops();
    }

    public LootTable.Builder createBlockDrops() {
        if (this.getPrimitiveCapBlock().isPresent()) {
            return DTPLootTableHandler.createCapBlockDrops(this.primitiveCap.m_60734_(), this.getMushroomItem(), -6, 2);
        }
        return DTPLootTableHandler.createCapDrops(this.primitiveCap.m_60734_(), this.getMushroomItem(), LootContextParamSets.f_81421_);
    }

    public ResourceLocation getLootTableName() {
        return this.lootTableSupplier.getName();
    }

    public LootTable getLootTable(LootDataManager lootTables, Species species) {
        return this.lootTableSupplier.get(lootTables, species);
    }

    public boolean shouldGenerateDrops() {
        return this.getPrimitiveCapBlock().isPresent();
    }

    public LootTable.Builder createDrops() {
        return DTPLootTableHandler.createCapDrops(this.primitiveCap.m_60734_(), this.getMushroomItem(), DTLootParameterSets.LEAVES);
    }

    public List<ItemStack> getDrops(Level level, BlockPos pos, ItemStack tool, Species species) {
        if (level.f_46443_) {
            return Collections.emptyList();
        }
        return this.getLootTable(Objects.requireNonNull(level.m_7654_()).m_278653_(), species).m_287195_(this.createLootParams(level, pos, tool, species));
    }

    private LootParams createLootParams(Level level, BlockPos pos, ItemStack tool, Species species) {
        return new LootParams.Builder(LevelContext.getServerLevelOrThrow((LevelAccessor)level)).m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287286_(DTLootContextParams.SPECIES, (Object)species).m_287286_(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(species.seasonalSeedDropFactor(LevelContext.create((LevelAccessor)level), pos))).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287235_(DTLootParameterSets.LEAVES);
    }

    public int getRadiusForConnection(BlockState state, BlockGetter blockAccess, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        if (from.getFamily() != this.family) {
            return 0;
        }
        return fromRadius;
    }

    public void generateStateData(DTBlockStateProvider provider) {
        ((Generator)this.capStateGenerator.get()).generate((DataProvider)provider, (Object)this);
        ((Generator)this.capCenterStateGenerator.get()).generate((DataProvider)provider, (Object)this);
    }

    public String getCapCenterAgeZeroModelName() {
        return "block/mushroom/" + this.centerBlockRegistryName.m_135815_() + "_age0";
    }

    public String getCapFaceModelName() {
        return "block/mushroom/" + this.blockRegistryName.m_135815_();
    }

    public String getCapInsideFaceModelName() {
        return "block/mushroom/" + this.blockRegistryName.m_135815_() + "_inside";
    }

    public ResourceLocation getCapCenterAgeZeroModelParent() {
        return this.getModelPath(CAP_CENTER_AGE_0_PARENT).orElse(new ResourceLocation("block/cube_bottom_top"));
    }

    public ResourceLocation getFaceModelParent() {
        return this.getModelPath(FACE).orElse(new ResourceLocation("block/template_single_face"));
    }

    public void setGenerateFaceModels(boolean generateFaceModels) {
        this.generateFaceModels = generateFaceModels;
    }

    public boolean shouldGenerateFaceModels() {
        return this.generateFaceModels;
    }

    public void addCapCenterAgeZeroTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation outsideTextureLocation, ResourceLocation insideTextureLocation) {
        ResourceLocation outLoc = this.getTexturePath(OUTSIDE_FACE).orElse(outsideTextureLocation);
        ResourceLocation inLoc = this.getTexturePath(INSIDE_FACE).orElse(insideTextureLocation);
        textureConsumer.accept("top", outLoc);
        textureConsumer.accept("bottom", inLoc);
        textureConsumer.accept("side", outLoc);
    }

    public void addCapFaceTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation textureLocation, boolean isInside) {
        ResourceLocation faceLoc = this.getTexturePath(isInside ? INSIDE_FACE : OUTSIDE_FACE).orElse(textureLocation);
        textureConsumer.accept("texture", faceLoc);
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }
}

