/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.utils.Comparators;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHelper {
    public static InteractionResultHolder<ItemStack> actionResultFromType(InteractionResult type, ItemStack stack) {
        return switch (type) {
            case InteractionResult.SUCCESS -> InteractionResultHolder.m_19090_((Object)stack);
            case InteractionResult.CONSUME -> InteractionResultHolder.m_19096_((Object)stack);
            case InteractionResult.FAIL -> InteractionResultHolder.m_19100_((Object)stack);
            default -> InteractionResultHolder.m_19098_((Object)stack);
        };
    }

    public static boolean checkItemNBT(ItemStack stack, String key) {
        return stack.m_41782_() && stack.m_41784_().m_128471_(key);
    }

    public static boolean compactInventory(IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            temp.add(stackInSlot);
            inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (ItemStack s : temp) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)s, (boolean)false);
        }
        return temp.isEmpty();
    }

    public static void compactItemListNoStacksize(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack s = list.get(i);
            if (s.m_41619_()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                ItemStack s1 = list.get(j);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)s1)) continue;
                s.m_41769_(s1.m_41613_());
                list.set(j, ItemStack.f_41583_);
            }
        }
        list.removeIf(ItemStack::m_41619_);
        list.sort(Comparators.ITEMSTACK_ASCENDING);
    }

    @Nullable
    public static CompoundTag copyNBTSkipKey(@NotNull CompoundTag nbt, @NotNull String keyToSkip) {
        CompoundTag copiedNBT = new CompoundTag();
        for (String key : nbt.m_128431_()) {
            Tag innerNBT;
            if (keyToSkip.equals(key) || (innerNBT = nbt.m_128423_(key)) == null) continue;
            copiedNBT.m_128365_(key, innerNBT.m_6426_());
        }
        if (copiedNBT.m_128456_()) {
            return null;
        }
        return copiedNBT;
    }

    public static ItemStack getNormalizedStack(ItemStack stack) {
        return stack.m_255036_(1);
    }

    public static IItemHandlerModifiable immutableCopy(IItemHandler toCopy) {
        final ArrayList<ItemStack> list = new ArrayList<ItemStack>(toCopy.getSlots());
        for (int i = 0; i < toCopy.getSlots(); ++i) {
            list.add(toCopy.getStackInSlot(i));
        }
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            }

            public int getSlots() {
                return list.size();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return (ItemStack)list.get(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return this.getStackInSlot(slot).m_41741_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }
        };
    }

    public static boolean isOre(BlockState state) {
        return state.m_204336_(Tags.Blocks.ORES);
    }

    public static boolean isRepairableDamagedItem(ItemStack stack) {
        return stack.m_41763_() && stack.isRepairable() && stack.m_41773_() > 0;
    }

    public static int simulateFit(NonNullList<ItemStack> inv, ItemStack stack) {
        int remainder = stack.m_41613_();
        for (ItemStack invStack : inv) {
            int amountSlotNeeds;
            if (invStack.m_41619_()) {
                return 0;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack) || (amountSlotNeeds = invStack.m_41741_() - invStack.m_41613_()) <= 0) continue;
            if (remainder <= amountSlotNeeds) {
                return 0;
            }
            remainder -= amountSlotNeeds;
        }
        return remainder;
    }

    @Nullable
    public static CompoundTag recombineNBT(List<CompoundTag> pieces) {
        if (pieces.isEmpty()) {
            return null;
        }
        CompoundTag combinedNBT = pieces.get(0);
        for (int i = 1; i < pieces.size(); ++i) {
            combinedNBT = combinedNBT.m_128391_(pieces.get(i));
        }
        return combinedNBT;
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return stack.m_255036_(size);
    }

    public static BlockState stackToState(ItemStack stack, @Nullable BlockPlaceContext context) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (context == null) {
                return blockItem.m_40614_().m_49966_();
            }
            return blockItem.m_40614_().m_5573_(context);
        }
        return null;
    }
}

