/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.BiMap;
import java.util.Collections;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WeatheringCopper;

@EMCMapper
public class WeatheredCopperMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        int recipeCount = 0;
        for (Map.Entry entry : ((BiMap)WeatheringCopper.f_154886_.get()).entrySet()) {
            NSSItem unweathered = NSSItem.createItem((ItemLike)entry.getKey());
            NSSItem weathered = NSSItem.createItem((ItemLike)entry.getValue());
            mapper.addConversion(1, (NormalizedSimpleStack)weathered, Collections.singleton(unweathered));
            mapper.addConversion(1, (NormalizedSimpleStack)unweathered, Collections.singleton(weathered));
            recipeCount += 2;
        }
        PECore.debugLog("WeatheredCopperMapper Statistics:", new Object[0]);
        PECore.debugLog("Found {} Weathered Copper Conversions", recipeCount);
    }

    @Override
    public String getName() {
        return "WeatheredCopperMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for all weathered copper variants";
    }
}

