/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config.value;

import moze_intel.projecte.config.IPEConfig;
import moze_intel.projecte.config.value.CachedValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedFloatValue
extends CachedValue<Double> {
    private boolean resolved;
    private float cachedValue;

    private CachedFloatValue(IPEConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        super(config, internal);
    }

    public static CachedFloatValue wrap(IPEConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        return new CachedFloatValue(config, internal);
    }

    public float getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return this.clampInternal((Double)this.internal.getDefault());
    }

    public float get() {
        if (!this.resolved) {
            this.cachedValue = this.clampInternal((Double)this.internal.get());
            this.resolved = true;
        }
        return this.cachedValue;
    }

    private float clampInternal(Double val) {
        if (val == null) {
            return 0.0f;
        }
        if (val > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        if (val < -3.4028234663852886E38) {
            return -3.4028235E38f;
        }
        return val.floatValue();
    }

    public void set(float value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        float oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

