/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;

public class FurnitureItem<T extends FurnitureEntity>
extends Item {
    private final Supplier<? extends EntityType<T>> entityType;
    private final DyeColor color;

    public FurnitureItem(Item.Properties properties, Supplier<? extends EntityType<T>> entityType, DyeColor color) {
        super(properties);
        this.entityType = entityType;
        this.color = color;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player placer, InteractionHand hand) {
        ItemStack heldItem = placer.m_21120_(hand);
        BlockHitResult rayTraceResult = FurnitureItem.m_41435_((Level)world, (Player)placer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (rayTraceResult.m_6662_() == HitResult.Type.MISS) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)heldItem);
        }
        Vec3 lookvec = placer.m_20252_(1.0f);
        List nearbyEntities = world.m_6249_((Entity)placer, placer.m_20191_().m_82369_(lookvec.m_82490_(5.0)).m_82400_(1.0), EntitySelector.f_20408_);
        if (!nearbyEntities.isEmpty()) {
            Vec3 eyePosition = placer.m_20299_(1.0f);
            for (Entity nearbyEnt : nearbyEntities) {
                AABB nearbyBB = nearbyEnt.m_20191_().m_82400_((double)nearbyEnt.m_6143_());
                if (!nearbyBB.m_82390_(eyePosition)) continue;
                return new InteractionResultHolder(InteractionResult.PASS, (Object)heldItem);
            }
        }
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hitVec = rayTraceResult.m_82450_();
            FurnitureEntity entity = (FurnitureEntity)this.entityType.get().m_20615_(world);
            entity.m_20035_(BlockPos.m_274446_((Position)hitVec), 0.0f, 0.0f);
            entity.m_20256_(Vec3.f_82478_);
            entity.setRotation(placer.m_146908_() + 180.0f);
            entity.setColor(this.color);
            if (!world.m_45756_((Entity)entity, entity.m_20191_().m_82400_(-0.1))) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldItem);
            }
            if (!world.f_46443_) {
                world.m_7967_((Entity)entity);
            }
            if (!placer.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            placer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)heldItem);
    }
}

