/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;

public class MonkeyPickUpPinaColadaGoal
extends Goal {
    private VMonkeyEntity entity;
    private ItemEntity drinkEntity;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public MonkeyPickUpPinaColadaGoal(VMonkeyEntity monkey) {
        this.entity = monkey;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.speedModifier = 1.0;
        this.stopDistance = 1.0f;
        this.navigation = this.entity.m_21573_();
        this.drinkEntity = null;
    }

    public boolean m_8045_() {
        return !this.entity.m_21824_() && !this.entity.selfHoldingDrink(Drink.PINA_COLADA) && this.drinkEntity != null;
    }

    public boolean m_8036_() {
        if (this.entity.m_217043_().m_188503_(20) != 0) {
            return false;
        }
        return !this.entity.m_21824_() && !this.entity.selfHoldingDrink(Drink.PINA_COLADA) && this.hasNearbyDrink(Drink.PINA_COLADA) && this.drinkEntity != null;
    }

    public void m_8041_() {
        this.navigation.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    private boolean hasNearbyDrink(Drink drink) {
        ItemStack stack = MixerRecipes.getItemStack(drink);
        List list = this.entity.m_9236_().m_45976_(ItemEntity.class, this.entity.m_20191_().m_82400_(10.0));
        if (!list.isEmpty()) {
            for (ItemEntity item : list) {
                if (item.m_20145_() || !ItemStack.m_150942_((ItemStack)item.m_32055_(), (ItemStack)stack) || !item.m_6084_()) continue;
                this.drinkEntity = item;
                return true;
            }
        }
        return false;
    }

    public void m_8037_() {
        if (this.drinkEntity != null && !this.entity.m_21523_()) {
            this.entity.m_21563_().m_24960_((Entity)this.drinkEntity, 10.0f, (float)this.entity.m_8132_());
            if (!this.drinkEntity.m_6084_()) {
                this.drinkEntity = null;
                this.entity.setMadAboutStolenAlcohol(true);
                return;
            }
            if (this.entity.m_20280_((Entity)this.drinkEntity) > (double)(this.stopDistance * this.stopDistance)) {
                if (--this.timeToRecalcPath <= 0) {
                    double d2;
                    double d1;
                    this.timeToRecalcPath = 10;
                    double d0 = this.entity.m_20185_() - this.drinkEntity.m_20185_();
                    double d3 = d0 * d0 + (d1 = this.entity.m_20186_() - this.drinkEntity.m_20186_()) * d1 + (d2 = this.entity.m_20189_() - this.drinkEntity.m_20189_()) * d2;
                    if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                        this.navigation.m_5624_((Entity)this.drinkEntity, this.speedModifier);
                    } else {
                        this.navigation.m_26573_();
                        if (d3 <= (double)this.stopDistance) {
                            double d4 = this.drinkEntity.m_20185_() - this.entity.m_20185_();
                            double d5 = this.drinkEntity.m_20189_() - this.entity.m_20189_();
                            this.navigation.m_26519_(this.entity.m_20185_() - d4, this.entity.m_20186_(), this.entity.m_20189_() - d5, this.speedModifier);
                        }
                    }
                }
            } else {
                this.entity.m_21008_(InteractionHand.MAIN_HAND, this.drinkEntity.m_32055_());
                this.drinkEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

