/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.noise;

import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.tropicraft.core.common.dimension.TropicraftSurfaces;
import net.tropicraft.core.common.dimension.noise.TropicraftNoiseRouterData;

public final class TropicraftNoiseGenSettings {
    public static final ResourceKey<NoiseGeneratorSettings> TROPICS = TropicraftNoiseGenSettings.createKey("tropics");

    public static void bootstrap(BootstapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunctions = context.m_255420_(Registries.f_257040_);
        HolderGetter noiseParameters = context.m_255420_(Registries.f_256865_);
        context.m_255272_(TROPICS, (Object)TropicraftNoiseGenSettings.createNoise((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noiseParameters, true));
    }

    public static NoiseGeneratorSettings createNoise(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters, boolean tropisurface) {
        NoiseSettings settings = NoiseSettings.m_224525_((int)-64, (int)384, (int)1, (int)2);
        SurfaceRules.RuleSource surface = tropisurface ? TropicraftSurfaces.tropics() : SurfaceRuleData.m_194807_();
        return new NoiseGeneratorSettings(settings, Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), TropicraftNoiseRouterData.tropics(densityFunctions, noiseParameters), surface, List.of(), 127, false, true, true, true);
    }

    private static ResourceKey<NoiseGeneratorSettings> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("tropicraft", name));
    }
}

