/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftFoliagePlacers;

public final class PapayaFoliagePlacer
extends FoliagePlacer {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Codec<PapayaFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> PapayaFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PapayaFoliagePlacer::new));

    public PapayaFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)TropicraftFoliagePlacers.PAPAYA.get();
    }

    protected void m_213633_(LevelSimulatedReader world, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment node, int pFoliageHeight, int radius, int pOffset) {
        this.m_225628_(world, setter, random, config, node.m_161451_(), 1, 1, node.m_68590_());
        BlockPos origin = node.m_161451_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 0; ++y) {
                    if (y == -1 && Math.abs(x) == 1 && Math.abs(z) == 1 && random.m_188499_()) continue;
                    BlockPos local = origin.m_7918_(x, y, z);
                    PapayaFoliagePlacer.set(world, local, random, config);
                }
            }
        }
        for (Direction direction : DIRECTIONS) {
            PapayaFoliagePlacer.set(world, origin.m_5484_(direction, 2), random, config);
            PapayaFoliagePlacer.set(world, origin.m_5484_(direction, 3), random, config);
            PapayaFoliagePlacer.set(world, origin.m_5484_(direction, 3).m_7495_(), random, config);
            PapayaFoliagePlacer.set(world, origin.m_5484_(direction, 4).m_7495_(), random, config);
        }
    }

    private static void set(LevelSimulatedReader world, BlockPos pos, RandomSource random, TreeConfiguration config) {
        if (TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos)) {
            ((LevelSimulatedRW)world).m_7731_(pos, config.f_161213_.m_213972_(random, pos), 19);
        }
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 0;
    }

    protected boolean m_214203_(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return radius != 0 && dx == radius && dz == radius;
    }
}

