/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import org.apache.commons.lang3.ArrayUtils;

public abstract class PalmTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = (Direction[])ArrayUtils.removeElement((Object[])Direction.values(), (Object)Direction.UP);

    public PalmTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected SaplingBlock getSapling() {
        return (SaplingBlock)TropicraftBlocks.PALM_SAPLING.get();
    }

    protected final BlockState getLeaf() {
        return ((LeavesBlock)TropicraftBlocks.PALM_LEAVES.get()).m_49966_();
    }

    protected final BlockState getLog() {
        return ((RotatedPillarBlock)TropicraftBlocks.PALM_LOG.get()).m_49966_();
    }

    protected boolean isAir(LevelReader level, BlockPos pos) {
        return level.m_46859_(pos);
    }

    protected void placeLeaf(LevelSimulatedRW world, int x, int y, int z) {
        this.placeLeaf(world, new BlockPos(x, y, z));
    }

    protected void placeLeaf(LevelSimulatedRW world, BlockPos pos) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos)) {
            this.m_5974_((LevelWriter)world, pos, this.getLeaf());
        }
    }

    protected void placeLog(LevelSimulatedRW world, int x, int y, int z) {
        this.placeLog(world, new BlockPos(x, y, z));
    }

    protected void placeLog(LevelSimulatedRW world, BlockPos pos) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos)) {
            this.m_5974_((LevelWriter)world, pos, this.getLog());
        }
    }

    public static void spawnCoconuts(LevelSimulatedRW world, BlockPos pos, RandomSource random, int chance, BlockState leaf) {
        BlockState coconut = ((CoconutBlock)((Object)TropicraftBlocks.COCONUT.get())).m_49966_();
        for (Direction d : DIRECTIONS) {
            BlockPos pos2 = pos.m_121945_(d);
            if (random.m_188503_(chance) != 0 || !TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos2)) continue;
            world.m_7731_(pos2, (BlockState)coconut.m_61124_((Property)CoconutBlock.f_52588_, (Comparable)d.m_122424_()), 3);
        }
    }
}

