/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.HugePlantFeature;
import net.tropicraft.core.common.dimension.feature.SimpleTreeFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftTreePlacements;
import net.tropicraft.core.common.dimension.feature.block_state_provider.NoiseFromTagBlockStateProvider;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;

public final class TropicraftVegetationFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAINFOREST_VINES = TropicraftVegetationFeatures.createKey("rainforest_vines");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_GOLDEN_LEATHER_FERN = TropicraftVegetationFeatures.createKey("small_golden_leather_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_GOLDEN_LEATHER_FERN = TropicraftVegetationFeatures.createKey("tall_golden_leather_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_GOLDEN_LEATHER_FERN = TropicraftVegetationFeatures.createKey("huge_golden_leather_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_FRUIT = TropicraftVegetationFeatures.createKey("trees_fruit");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_PALM = TropicraftVegetationFeatures.createKey("trees_palm");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_MANGROVE = TropicraftVegetationFeatures.createKey("trees_mangroves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_RAINFOREST = TropicraftVegetationFeatures.createKey("trees_rainforest");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_PAPAYA = TropicraftVegetationFeatures.createKey("trees_papaya");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_PLEODENDRON = TropicraftVegetationFeatures.createKey("trees_pleodendron");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GRASS_TROPICS = TropicraftVegetationFeatures.createKey("patch_grass_tropics");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINEAPPLE = TropicraftVegetationFeatures.createKey("pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_PINEAPPLE = TropicraftVegetationFeatures.createKey("patch_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_IRIS = TropicraftVegetationFeatures.createKey("iris_flowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BAMBOO = TropicraftVegetationFeatures.createKey("bamboo");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWERS_TROPICS = TropicraftVegetationFeatures.createKey("flowers_tropics");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWERS_RAINFOREST = TropicraftVegetationFeatures.createKey("flowers_rainforest");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COFFEE_BUSH = TropicraftVegetationFeatures.createKey("coffee_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UNDERGROWTH = TropicraftVegetationFeatures.createKey("undergrowth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_UNDERGROWTH = TropicraftVegetationFeatures.createKey("single_undergrowth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_FLOWERING_BUSH = TropicraftVegetationFeatures.createKey("red_flowering_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_FLOWERING_BUSH = TropicraftVegetationFeatures.createKey("white_flowering_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_FLOWERING_BUSH = TropicraftVegetationFeatures.createKey("blue_flowering_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PURPLE_FLOWERING_BUSH = TropicraftVegetationFeatures.createKey("purple_flowering_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_FLOWERING_BUSH = TropicraftVegetationFeatures.createKey("yellow_flowering_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BUSH_FLOWERING = TropicraftVegetationFeatures.createKey("flowering_bushes");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEAGRASS = TropicraftVegetationFeatures.createKey("seagrass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UNDERGROUND_SEAGRASS = TropicraftVegetationFeatures.createKey("underground_seagrass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UNDERGROUND_SEA_PICKLES = TropicraftVegetationFeatures.createKey("underground_sea_pickles");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANGROVE_REEDS = TropicraftVegetationFeatures.createKey("mangrove_reeds");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TROPI_SEAGRASS = TropicraftVegetationFeatures.createKey("tropi_seagrass");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TropicraftFeatureUtil.register(context, RAINFOREST_VINES, TropicraftFeatures.VINES, new RainforestVinesConfig());
        TropicraftFeatureUtil.register(context, SMALL_GOLDEN_LEATHER_FERN, Feature.f_65763_, TropicraftFeatureUtil.randomPatch(TropicraftBlocks.GOLDEN_LEATHER_FERN));
        TropicraftFeatureUtil.register(context, TALL_GOLDEN_LEATHER_FERN, Feature.f_65763_, TropicraftFeatureUtil.randomPatch(TropicraftBlocks.TALL_GOLDEN_LEATHER_FERN));
        TropicraftFeatureUtil.register(context, HUGE_GOLDEN_LEATHER_FERN, Feature.f_65763_, FeatureUtils.m_206473_((Feature)((HugePlantFeature)((Object)TropicraftFeatures.HUGE_PLANT.get())), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TropicraftBlocks.LARGE_GOLDEN_LEATHER_FERN.get())))));
        TropicraftFeatureUtil.registerRandomPlaced(context, TREES_FRUIT, TropicraftTreePlacements.GRAPEFRUIT_TREE_CHECKED, TropicraftTreePlacements.ORANGE_TREE_CHECKED, TropicraftTreePlacements.LEMON_TREE_CHECKED, TropicraftTreePlacements.LIME_TREE_CHECKED);
        TropicraftFeatureUtil.registerRandomPlaced(context, TREES_PALM, TropicraftTreePlacements.PALM_TREE_CHECKED);
        TropicraftFeatureUtil.registerRandomPlaced(context, TREES_MANGROVE, TropicraftTreePlacements.RED_MANGROVE_CHECKED, TropicraftTreePlacements.LIGHT_MANGROVES_CHECKED);
        TropicraftFeatureUtil.registerRandom(context, TREES_RAINFOREST, List.of(Pair.of(TropicraftTreePlacements.RAINFOREST_UP_TREE_CHECKED, (Object)Float.valueOf(0.2f)), Pair.of(TropicraftTreePlacements.RAINFOREST_SMALL_TUALUNG_CHECKED, (Object)Float.valueOf(0.25f)), Pair.of(TropicraftTreePlacements.RAINFOREST_LARGE_TUALUNG_CHECKED, (Object)Float.valueOf(0.5f))), TropicraftTreePlacements.RAINFOREST_TALL_TREE_CHECKED);
        TropicraftFeatureUtil.registerRandomPlaced(context, TREES_PAPAYA, TropicraftTreePlacements.PAPAYA_CHECKED);
        TropicraftFeatureUtil.registerRandomPlaced(context, TREES_PLEODENDRON, TropicraftTreePlacements.PLEODENDRON_CHECKED);
        TropicraftFeatureUtil.register(context, PATCH_GRASS_TROPICS, Feature.f_65763_, new RandomPatchConfiguration(32, 7, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50034_.m_49966_(), 3).m_146271_((Object)Blocks.f_50035_.m_49966_(), 1))), (BlockPredicate)BlockPredicate.f_190393_)));
        TropicraftFeatureUtil.register(context, PINEAPPLE, Feature.f_65741_, new SimpleBlockConfiguration(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.PINEAPPLE)));
        TropicraftFeatureUtil.register(context, PATCH_PINEAPPLE, Feature.f_65763_, TropicraftFeatureUtil.randomPatch(TropicraftBlocks.PINEAPPLE));
        TropicraftFeatureUtil.register(context, PATCH_IRIS, Feature.f_65763_, TropicraftFeatureUtil.randomPatch(TropicraftBlocks.IRIS));
        TropicraftFeatureUtil.register(context, BAMBOO, Feature.f_65742_, new ProbabilityFeatureConfiguration(0.15f));
        TropicraftFeatureUtil.register(context, FLOWERS_TROPICS, Feature.f_65761_, TropicraftFeatureUtil.randomPatch(new NoiseFromTagBlockStateProvider(TropicraftTags.Blocks.TROPICS_FLOWERS)));
        TropicraftFeatureUtil.register(context, FLOWERS_RAINFOREST, Feature.f_65761_, TropicraftFeatureUtil.randomPatch(new NoiseFromTagBlockStateProvider(TropicraftTags.Blocks.RAINFOREST_FLOWERS)));
        TropicraftFeatureUtil.register(context, COFFEE_BUSH, TropicraftFeatures.COFFEE_BUSH);
        TropicraftFeatureUtil.register(context, UNDERGROWTH, TropicraftFeatures.UNDERGROWTH);
        TropicraftFeatureUtil.register(context, SINGLE_UNDERGROWTH, TropicraftFeatures.SINGLE_UNDERGROWTH, new SimpleTreeFeatureConfig(() -> ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_(), () -> ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).m_49966_()));
        TropicraftFeatureUtil.register(context, RED_FLOWERING_BUSH, TropicraftFeatures.SINGLE_UNDERGROWTH, new SimpleTreeFeatureConfig(() -> ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_(), () -> ((LeavesBlock)TropicraftBlocks.RED_FLOWERING_LEAVES.get()).m_49966_()));
        TropicraftFeatureUtil.register(context, WHITE_FLOWERING_BUSH, TropicraftFeatures.SINGLE_UNDERGROWTH, new SimpleTreeFeatureConfig(() -> ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_(), () -> ((LeavesBlock)TropicraftBlocks.WHITE_FLOWERING_LEAVES.get()).m_49966_()));
        TropicraftFeatureUtil.register(context, BLUE_FLOWERING_BUSH, TropicraftFeatures.SINGLE_UNDERGROWTH, new SimpleTreeFeatureConfig(() -> ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_(), () -> ((LeavesBlock)TropicraftBlocks.BLUE_FLOWERING_LEAVES.get()).m_49966_()));
        TropicraftFeatureUtil.register(context, PURPLE_FLOWERING_BUSH, TropicraftFeatures.SINGLE_UNDERGROWTH, new SimpleTreeFeatureConfig(() -> ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_(), () -> ((LeavesBlock)TropicraftBlocks.PURPLE_FLOWERING_LEAVES.get()).m_49966_()));
        TropicraftFeatureUtil.register(context, YELLOW_FLOWERING_BUSH, TropicraftFeatures.SINGLE_UNDERGROWTH, new SimpleTreeFeatureConfig(() -> ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_(), () -> ((LeavesBlock)TropicraftBlocks.YELLOW_FLOWERING_LEAVES.get()).m_49966_()));
        TropicraftFeatureUtil.registerRandom(context, BUSH_FLOWERING, RED_FLOWERING_BUSH, WHITE_FLOWERING_BUSH, BLUE_FLOWERING_BUSH, PURPLE_FLOWERING_BUSH, YELLOW_FLOWERING_BUSH);
        TropicraftFeatureUtil.register(context, SEAGRASS, Feature.f_65735_, new ProbabilityFeatureConfiguration(0.3f));
        TropicraftFeatureUtil.register(context, UNDERGROUND_SEAGRASS, Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50037_)));
        TropicraftFeatureUtil.register(context, UNDERGROUND_SEA_PICKLES, TropicraftFeatures.UNDERGROUND_SEA_PICKLE);
        TropicraftFeatureUtil.register(context, MANGROVE_REEDS, TropicraftFeatures.REEDS);
        TropicraftFeatureUtil.register(context, TROPI_SEAGRASS, TropicraftFeatures.SEAGRASS);
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("tropicraft", name));
    }
}

