/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.dimension.TropicsTeleporter;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeBuilder;
import net.tropicraft.core.common.dimension.noise.TropicraftNoiseGenSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="tropicraft")
public class TropicraftDimension {
    private static final Logger LOGGER = LogManager.getLogger(TropicraftDimension.class);
    public static final ResourceLocation ID;
    public static final ResourceLocation EFFECTS_ID;
    public static final ResourceKey<Level> WORLD;
    public static final ResourceKey<LevelStem> DIMENSION;
    public static final ResourceKey<DimensionType> DIMENSION_TYPE;
    public static final int SEA_LEVEL = 127;

    public static void bootstrapDimensionType(BootstapContext<DimensionType> context) {
        context.m_255272_(DIMENSION_TYPE, (Object)new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, true, false, -64, 384, 384, BlockTags.f_13058_, EFFECTS_ID, 0.0f, new DimensionType.MonsterSettings(false, true, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 0)));
    }

    public static void bootstrapLevelStem(BootstapContext<LevelStem> context) {
        context.m_255272_(DIMENSION, (Object)new LevelStem((Holder)context.m_255420_(Registries.f_256787_).m_255043_(DIMENSION_TYPE), (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.m_274591_((Holder)context.m_255420_(Registries.f_273919_).m_255043_(TropicraftBiomeBuilder.PARAMETER_LIST)), (Holder)context.m_255420_(Registries.f_256932_).m_255043_(TropicraftNoiseGenSettings.TROPICS))));
    }

    public static void teleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionType) {
        ServerLevel destLevel = TropicraftDimension.getTeleportDestination(player, dimensionType);
        if (destLevel == null) {
            return;
        }
        ResourceKey destDimension = destLevel.m_46472_();
        if (!ForgeHooks.onTravelToDimension((Entity)player, (ResourceKey)destDimension)) {
            return;
        }
        int x = Mth.m_14107_((double)player.m_20185_());
        int z = Mth.m_14107_((double)player.m_20189_());
        LevelChunk chunk = destLevel.m_6325_(x >> 4, z >> 4);
        int topY = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x & 0xF, z & 0xF);
        player.m_8999_(destLevel, (double)x + 0.5, (double)topY + 1.0, (double)z + 0.5, player.m_146908_(), player.m_146909_());
        ForgeEventFactory.firePlayerChangedDimensionEvent((Player)player, (ResourceKey)destDimension, (ResourceKey)destDimension);
    }

    public static void teleportPlayerWithPortal(ServerPlayer player, ResourceKey<Level> dimensionType) {
        ServerLevel destLevel = TropicraftDimension.getTeleportDestination(player, dimensionType);
        if (destLevel == null) {
            return;
        }
        if (!player.m_20092_()) {
            player.m_19877_();
            player.changeDimension(destLevel, (ITeleporter)new TropicsTeleporter(destLevel));
            player.f_19839_ = 160;
        }
    }

    @Nullable
    private static ServerLevel getTeleportDestination(ServerPlayer player, ResourceKey<Level> dimensionType) {
        ResourceKey<Level> destination = player.m_9236_().m_46472_() == dimensionType ? Level.f_46428_ : dimensionType;
        ServerLevel destLevel = player.f_8924_.m_129880_(destination);
        if (destLevel == null) {
            LOGGER.error("Cannot teleport player to dimension {} as it does not exist!", (Object)destination.m_135782_());
            return null;
        }
        return destLevel;
    }

    public static int getSeaLevel(LevelReader reader) {
        Level level;
        if (reader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)reader;
            ServerChunkCache chunkProvider = serverLevel.m_7726_();
            return chunkProvider.m_8481_().m_6337_();
        }
        if (reader instanceof Level && (level = (Level)reader).m_46472_() == WORLD) {
            return 127;
        }
        return reader.m_5736_();
    }

    static {
        EFFECTS_ID = ID = new ResourceLocation("tropicraft", "tropics");
        WORLD = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ID);
        DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)ID);
        DIMENSION_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)ID);
    }
}

