/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.scuba;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaData;
import org.apache.commons.lang3.time.DurationFormatUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaHUD {
    @SubscribeEvent
    public static void registerOverlayRenderer(RegisterGuiOverlaysEvent event) {
        event.registerBelow(new ResourceLocation("debug_text"), "scuba_hud", ScubaHUD::draw);
    }

    private static void draw(ForgeGui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        Player player;
        ItemStack chestStack;
        Item item;
        Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
        if (renderViewEntity instanceof Player && (item = (chestStack = (player = (Player)renderViewEntity).m_6844_(EquipmentSlot.CHEST)).m_41720_()) instanceof ScubaArmorItem) {
            ScubaArmorItem scuba = (ScubaArmorItem)item;
            LazyOptional data = player.getCapability(ScubaData.CAPABILITY);
            int airRemaining = scuba.getRemainingAir(chestStack);
            ChatFormatting airColor = ScubaHUD.getAirTimeColor(airRemaining, player.m_9236_());
            double depth = ScubaData.getDepth(player);
            Object depthStr = depth > 0.0 ? Component.m_237113_((String)String.format("%.1fm", depth)) : TropicraftLangKeys.NA.component();
            data.ifPresent(arg_0 -> ScubaHUD.lambda$draw$0(graphics, airColor, airRemaining, (Component)depthStr, arg_0));
        }
    }

    public static String formatTime(long time) {
        return DurationFormatUtils.formatDuration((long)(time * 50L), (String)"HH:mm:ss");
    }

    public static ChatFormatting getAirTimeColor(int airRemaining, @Nullable Level world) {
        if (airRemaining < 1200) {
            int speed = airRemaining < 200 ? 5 : 10;
            return world != null && world.m_46467_() / (long)speed % 4L == 0L ? ChatFormatting.WHITE : ChatFormatting.RED;
        }
        if (airRemaining < 6000) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.GREEN;
    }

    private static void drawHUDStrings(GuiGraphics graphics, Component ... lines) {
        Font font = Minecraft.m_91087_().f_91062_;
        int x = graphics.m_280182_() - 5;
        int n = graphics.m_280206_() - 5;
        Objects.requireNonNull(font);
        int y = n - 9 * lines.length;
        for (Component line : lines) {
            graphics.m_280430_(font, line, x - font.m_92852_((FormattedText)line), y, -1);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    private static /* synthetic */ void lambda$draw$0(GuiGraphics graphics, ChatFormatting airColor, int airRemaining, Component depthStr, ScubaData d) {
        ScubaHUD.drawHUDStrings(graphics, TropicraftLangKeys.SCUBA_AIR_TIME.format(airColor + ScubaHUD.formatTime(airRemaining)), TropicraftLangKeys.SCUBA_DIVE_TIME.format(ScubaHUD.formatTime(d.getDiveTime())), TropicraftLangKeys.SCUBA_DEPTH.format(depthStr), TropicraftLangKeys.SCUBA_MAX_DEPTH.format(String.format("%.1fm", d.getMaxDepth())));
    }
}

