/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import org.joml.Quaternionf;

public class FurnitureRenderer<T extends FurnitureEntity>
extends EntityRenderer<T> {
    private static final Axis DEFAULT_ROCKING_AXIS = angle -> new Quaternionf().rotationAxis(angle, 1.0f, 0.0f, 1.0f);
    private final String textureName;
    private final EntityModel<T> model;
    private final float scale;

    public FurnitureRenderer(EntityRendererProvider.Context context, String textureName, EntityModel<T> model) {
        this(context, textureName, model, 1.0f);
    }

    public FurnitureRenderer(EntityRendererProvider.Context context, String textureName, EntityModel<T> model, float scale) {
        super(context);
        this.textureName = textureName;
        this.model = model;
        this.scale = scale;
    }

    public void render(T furniture, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLightIn) {
        stack.m_85836_();
        stack.m_85837_(0.0, this.getYOffset(), 0.0);
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        stack.m_85841_(this.scale, this.scale, this.scale);
        this.setupTransforms(stack);
        float rockingAngle = this.getRockingAngle(furniture, partialTicks);
        if (!Mth.m_14033_((float)rockingAngle, (float)0.0f)) {
            stack.m_252781_(this.getRockingAxis().m_252977_(rockingAngle));
        }
        float[] color = ((FurnitureEntity)((Object)furniture)).getColor().m_41068_();
        float red = color[0];
        float green = color[1];
        float blue = color[2];
        VertexConsumer ivertexbuilder = buffer.m_6299_(this.model.m_103119_(TropicraftRenderUtils.getTextureEntity(this.textureName + "_base_layer")));
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_7695_(stack, ivertexbuilder, this.m_114505_((Entity)furniture, partialTicks), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        ivertexbuilder = buffer.m_6299_(this.model.m_103119_(TropicraftRenderUtils.getTextureEntity(this.textureName + "_color_layer")));
        this.model.m_7695_(stack, ivertexbuilder, this.m_114505_((Entity)furniture, partialTicks), OverlayTexture.f_118083_, red, green, blue, 1.0f);
        super.m_7392_(furniture, entityYaw, partialTicks, stack, buffer, packedLightIn);
        stack.m_85849_();
    }

    protected double getYOffset() {
        return 0.3125;
    }

    protected void setupTransforms(PoseStack stack) {
    }

    protected float getRockingAngle(T entity, float partialTicks) {
        float f2 = (float)((FurnitureEntity)((Object)entity)).getTimeSinceHit() - partialTicks;
        float f3 = ((FurnitureEntity)((Object)entity)).getDamage() - partialTicks;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            return Mth.m_14031_((float)f2) * f2 * f3 / this.getRockAmount() * (float)((FurnitureEntity)((Object)entity)).getForwardDirection();
        }
        return 0.0f;
    }

    protected Axis getRockingAxis() {
        return DEFAULT_ROCKING_AXIS;
    }

    protected float getRockAmount() {
        return 10.0f;
    }

    public ResourceLocation getTextureLocation(T furniture) {
        return null;
    }
}

