/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import snownee.kiwi.KiwiModule;

public class CustomizationCodecs {
    public static final BiMap<ResourceLocation, SoundType> SOUND_TYPES = HashBiMap.create();
    public static final Codec<SoundType> SOUND_TYPE_CODEC = CustomizationCodecs.simpleByNameCodec(SOUND_TYPES);
    public static final BiMap<String, NoteBlockInstrument> INSTRUMENTS = HashBiMap.create();
    public static final Codec<NoteBlockInstrument> INSTRUMENT_CODEC = CustomizationCodecs.simpleByNameCodec(INSTRUMENTS);
    public static final BiMap<String, MapColor> MAP_COLORS = HashBiMap.create();
    public static final Codec<MapColor> MAP_COLOR_CODEC = CustomizationCodecs.simpleByNameCodec(MAP_COLORS);
    public static final Codec<PushReaction> PUSH_REACTION = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"normal", (Object)PushReaction.NORMAL, (Object)"destroy", (Object)PushReaction.DESTROY, (Object)"block", (Object)PushReaction.BLOCK, (Object)"ignore", (Object)PushReaction.IGNORE, (Object)"push_only", (Object)PushReaction.PUSH_ONLY));
    public static final Codec<KiwiModule.RenderLayer.Layer> RENDER_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"cutout", (Object)((Object)KiwiModule.RenderLayer.Layer.CUTOUT), (Object)"cutout_mipped", (Object)((Object)KiwiModule.RenderLayer.Layer.CUTOUT_MIPPED), (Object)"translucent", (Object)((Object)KiwiModule.RenderLayer.Layer.TRANSLUCENT)));
    public static final Codec<BlockBehaviour.OffsetType> OFFSET_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"xz", (Object)BlockBehaviour.OffsetType.XZ, (Object)"xyz", (Object)BlockBehaviour.OffsetType.XYZ));
    public static final Codec<BlockBehaviour.StatePredicate> STATE_PREDICATE = Codec.BOOL.flatComapMap(bl -> bl != false ? Blocks::m_50774_ : Blocks::m_50805_, p -> DataResult.error(() -> "Unsupported operation"));
    public static final Codec<Direction> DIRECTION = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"down", (Object)Direction.DOWN, (Object)"up", (Object)Direction.UP, (Object)"north", (Object)Direction.NORTH, (Object)"south", (Object)Direction.SOUTH, (Object)"west", (Object)Direction.WEST, (Object)"east", (Object)Direction.EAST));
    public static final Codec<MinMaxBounds.Ints> INT_BOUNDS = ExtraCodecs.f_252400_.xmap(MinMaxBounds.Ints::m_55373_, MinMaxBounds::m_55328_);
    public static final Codec<BlockPredicate> BLOCK_PREDICATE = new Codec<BlockPredicate>(){

        public <T> DataResult<Pair<BlockPredicate, T>> decode(DynamicOps<T> ops, T input) {
            String stringValue = ops.getStringValue(input).result().orElse(null);
            if (stringValue != null) {
                if (stringValue.startsWith("#")) {
                    return DataResult.success((Object)Pair.of((Object)BlockPredicate.Builder.m_17924_().m_204027_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(stringValue.substring(1)))).m_17931_(), (Object)ops.empty()));
                }
                return DataResult.success((Object)Pair.of((Object)BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{(Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(stringValue))}).m_17931_(), (Object)ops.empty()));
            }
            return ExtraCodecs.f_252400_.decode(ops, input).map($ -> $.mapFirst(BlockPredicate::m_17917_));
        }

        public <T> DataResult<T> encode(BlockPredicate input, DynamicOps<T> ops, T prefix) {
            return ExtraCodecs.f_252400_.encodeStart(ops, (Object)input.m_17913_());
        }
    };
    public static final Codec<BlockSetType> BLOCK_SET_TYPE = ExtraCodecs.m_184405_(BlockSetType::f_271253_, s -> BlockSetType.m_271801_().filter(e -> e.f_271253_().equals(s)).findFirst().orElseThrow());
    public static final Codec<WoodType> WOOD_TYPE = ExtraCodecs.m_184405_(WoodType::f_61839_, s -> WoodType.m_61843_().filter(e -> e.f_61839_().equals(s)).findFirst().orElseThrow());
    public static final BiMap<String, PressurePlateBlock.Sensitivity> SENSITIVITIES = HashBiMap.create();
    public static final Codec<PressurePlateBlock.Sensitivity> SENSITIVITY_CODEC = CustomizationCodecs.simpleByNameCodec(SENSITIVITIES);
    public static final Codec<WeatheringCopper.WeatherState> WEATHER_STATE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"unaffected", (Object)WeatheringCopper.WeatherState.UNAFFECTED, (Object)"exposed", (Object)WeatheringCopper.WeatherState.EXPOSED, (Object)"weathered", (Object)WeatheringCopper.WeatherState.WEATHERED, (Object)"oxidized", (Object)WeatheringCopper.WeatherState.OXIDIZED));
    public static final Codec<MobEffectInstance> MOB_EFFECT_INSTANCE = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("id").forGetter(MobEffectInstance::m_19544_), (App)ExtraCodecs.f_144628_.optionalFieldOf("amplifier", (Object)0).forGetter(MobEffectInstance::m_19564_), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(MobEffectInstance::m_19557_), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::m_19571_), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(MobEffectInstance::m_19572_), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(MobEffectInstance::m_19575_)).apply((Applicative)instance, MobEffectInstance::new));
    public static final Codec<Pair<MobEffectInstance, Float>> POSSIBLE_EFFECT = RecordCodecBuilder.create(instance -> instance.group((App)MOB_EFFECT_INSTANCE.fieldOf("effect").forGetter(Pair::getFirst), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    public static final Codec<FoodProperties> FOOD = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("nutrition").forGetter(FoodProperties::m_38744_), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FoodProperties::m_38745_), (App)Codec.BOOL.optionalFieldOf("meat", (Object)false).forGetter(FoodProperties::m_38746_), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodProperties::m_38747_), (App)Codec.BOOL.optionalFieldOf("fast_food", (Object)false).forGetter(FoodProperties::m_38748_), (App)POSSIBLE_EFFECT.listOf().optionalFieldOf("effects", List.of()).forGetter(FoodProperties::m_38749_)).apply((Applicative)instance, FoodProperties::new));
    public static final BiMap<String, Rarity> RARITIES = HashBiMap.create(Map.of("common", Rarity.COMMON, "uncommon", Rarity.UNCOMMON, "rare", Rarity.RARE, "epic", Rarity.EPIC));
    public static final Codec<Rarity> RARITY_CODEC = CustomizationCodecs.simpleByNameCodec(RARITIES);
    public static final Codec<ArmorItem.Type> ARMOR_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"helmet", (Object)ArmorItem.Type.HELMET, (Object)"chestplate", (Object)ArmorItem.Type.CHESTPLATE, (Object)"leggings", (Object)ArmorItem.Type.LEGGINGS, (Object)"boots", (Object)ArmorItem.Type.BOOTS));
    public static final BiMap<ResourceLocation, ArmorMaterial> CUSTOM_ARMOR_MATERIALS = HashBiMap.create();
    public static final Codec<ArmorMaterial> ARMOR_MATERIAL = CustomizationCodecs.withAlternative((Codec)StringRepresentable.m_216439_(ArmorMaterials::values), CustomizationCodecs.simpleByNameCodec(CUSTOM_ARMOR_MATERIALS));

    public static <T> Codec<T> simpleByNameCodec(Map<ResourceLocation, T> map) {
        return ResourceLocation.f_135803_.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + key);
            }
            return DataResult.success(value);
        }, value -> DataResult.error(() -> "Unsupported operation"));
    }

    public static <T> Codec<T> simpleByNameCodec(BiMap<String, T> map) {
        return CustomizationCodecs.simpleByNameCodec(map, Codec.STRING);
    }

    public static <K, V> Codec<V> simpleByNameCodec(BiMap<K, V> map, Codec<K> keyCodec) {
        return keyCodec.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + key);
            }
            return DataResult.success((Object)value);
        }, value -> {
            Object key = map.inverse().get(value);
            if (key == null) {
                return DataResult.error(() -> "Unknown value: " + value);
            }
            return DataResult.success((Object)key);
        });
    }

    public static <T> Codec<BlockBehaviour.StateArgumentPredicate<T>> stateArgumentPredicate() {
        return new Codec<BlockBehaviour.StateArgumentPredicate<T>>(){

            public <R> DataResult<R> encode(BlockBehaviour.StateArgumentPredicate<T> input, DynamicOps<R> ops, R prefix) {
                return DataResult.error(() -> "Unsupported operation");
            }

            public <R> DataResult<Pair<BlockBehaviour.StateArgumentPredicate<T>, R>> decode(DynamicOps<R> ops, R input) {
                String s;
                Optional booleanValue = ops.getBooleanValue(input).result();
                if (booleanValue.isPresent()) {
                    BlockBehaviour.StateArgumentPredicate predicate = (Boolean)booleanValue.get() != false ? CustomizationCodecs::always : CustomizationCodecs::never;
                    return DataResult.success((Object)Pair.of((Object)predicate, (Object)ops.empty()));
                }
                Optional stringValue = ops.getStringValue(input).result();
                if (stringValue.isPresent() && "ocelot_or_parrot".equals(s = (String)stringValue.get())) {
                    return DataResult.success((Object)Pair.of((state, world, pos, entity) -> entity == EntityType.f_20505_ || entity == EntityType.f_20508_, (Object)ops.empty()));
                }
                return DataResult.error(() -> "Failed to decode state argument predicate: " + input);
            }
        };
    }

    public static <T> boolean always(BlockState blockState, BlockGetter blockGetter, BlockPos pos, T t) {
        return true;
    }

    public static <T> boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos pos, T t) {
        return false;
    }

    public static <T> Codec<T> withAlternative(Codec<T> codec, Codec<? extends T> codec2) {
        return new ExtraCodecs.EitherCodec(codec, codec2).xmap(either -> either.map(object -> object, object -> object), Either::left);
    }

    public static <T> Codec<List<T>> compactList(Codec<T> codec) {
        return CustomizationCodecs.withAlternative(codec.listOf(), codec.xmap(List::of, list -> list.get(0)));
    }

    public static <A> MapCodec<Optional<A>> strictOptionalField(Codec<A> codec, String string) {
        return new StrictOptionalFieldCodec<A>(string, codec);
    }

    public static <A> MapCodec<A> strictOptionalField(Codec<A> codec, String string, A object) {
        return CustomizationCodecs.strictOptionalField(codec, string).xmap(optional -> optional.orElse(object), object2 -> Objects.equals(object2, object) ? Optional.empty() : Optional.of(object2));
    }

    static {
        SOUND_TYPES.put((Object)new ResourceLocation("empty"), (Object)SoundType.f_279557_);
        SOUND_TYPES.put((Object)new ResourceLocation("wood"), (Object)SoundType.f_56736_);
        SOUND_TYPES.put((Object)new ResourceLocation("gravel"), (Object)SoundType.f_56739_);
        SOUND_TYPES.put((Object)new ResourceLocation("grass"), (Object)SoundType.f_56740_);
        SOUND_TYPES.put((Object)new ResourceLocation("lily_pad"), (Object)SoundType.f_56741_);
        SOUND_TYPES.put((Object)new ResourceLocation("stone"), (Object)SoundType.f_56742_);
        SOUND_TYPES.put((Object)new ResourceLocation("metal"), (Object)SoundType.f_56743_);
        SOUND_TYPES.put((Object)new ResourceLocation("glass"), (Object)SoundType.f_56744_);
        SOUND_TYPES.put((Object)new ResourceLocation("wool"), (Object)SoundType.f_56745_);
        SOUND_TYPES.put((Object)new ResourceLocation("sand"), (Object)SoundType.f_56746_);
        SOUND_TYPES.put((Object)new ResourceLocation("snow"), (Object)SoundType.f_56747_);
        SOUND_TYPES.put((Object)new ResourceLocation("powder_snow"), (Object)SoundType.f_154681_);
        SOUND_TYPES.put((Object)new ResourceLocation("ladder"), (Object)SoundType.f_56748_);
        SOUND_TYPES.put((Object)new ResourceLocation("anvil"), (Object)SoundType.f_56749_);
        SOUND_TYPES.put((Object)new ResourceLocation("slime_block"), (Object)SoundType.f_56750_);
        SOUND_TYPES.put((Object)new ResourceLocation("honey_block"), (Object)SoundType.f_56751_);
        SOUND_TYPES.put((Object)new ResourceLocation("wet_grass"), (Object)SoundType.f_56752_);
        SOUND_TYPES.put((Object)new ResourceLocation("coral_block"), (Object)SoundType.f_56753_);
        SOUND_TYPES.put((Object)new ResourceLocation("bamboo"), (Object)SoundType.f_56754_);
        SOUND_TYPES.put((Object)new ResourceLocation("bamboo_sapling"), (Object)SoundType.f_56755_);
        SOUND_TYPES.put((Object)new ResourceLocation("scaffolding"), (Object)SoundType.f_56756_);
        SOUND_TYPES.put((Object)new ResourceLocation("sweet_berry_bush"), (Object)SoundType.f_56757_);
        SOUND_TYPES.put((Object)new ResourceLocation("crop"), (Object)SoundType.f_56758_);
        SOUND_TYPES.put((Object)new ResourceLocation("hard_crop"), (Object)SoundType.f_56759_);
        SOUND_TYPES.put((Object)new ResourceLocation("vine"), (Object)SoundType.f_56760_);
        SOUND_TYPES.put((Object)new ResourceLocation("nether_wart"), (Object)SoundType.f_56761_);
        SOUND_TYPES.put((Object)new ResourceLocation("lantern"), (Object)SoundType.f_56762_);
        SOUND_TYPES.put((Object)new ResourceLocation("stem"), (Object)SoundType.f_56763_);
        SOUND_TYPES.put((Object)new ResourceLocation("nylium"), (Object)SoundType.f_56710_);
        SOUND_TYPES.put((Object)new ResourceLocation("fungus"), (Object)SoundType.f_56711_);
        SOUND_TYPES.put((Object)new ResourceLocation("roots"), (Object)SoundType.f_56712_);
        SOUND_TYPES.put((Object)new ResourceLocation("shroomlight"), (Object)SoundType.f_56713_);
        SOUND_TYPES.put((Object)new ResourceLocation("weeping_vines"), (Object)SoundType.f_56714_);
        SOUND_TYPES.put((Object)new ResourceLocation("twisting_vines"), (Object)SoundType.f_56715_);
        SOUND_TYPES.put((Object)new ResourceLocation("soul_sand"), (Object)SoundType.f_56716_);
        SOUND_TYPES.put((Object)new ResourceLocation("soul_soil"), (Object)SoundType.f_56717_);
        SOUND_TYPES.put((Object)new ResourceLocation("basalt"), (Object)SoundType.f_56718_);
        SOUND_TYPES.put((Object)new ResourceLocation("wart_block"), (Object)SoundType.f_56719_);
        SOUND_TYPES.put((Object)new ResourceLocation("netherrack"), (Object)SoundType.f_56720_);
        SOUND_TYPES.put((Object)new ResourceLocation("nether_bricks"), (Object)SoundType.f_56721_);
        SOUND_TYPES.put((Object)new ResourceLocation("nether_sprouts"), (Object)SoundType.f_56722_);
        SOUND_TYPES.put((Object)new ResourceLocation("nether_ore"), (Object)SoundType.f_56723_);
        SOUND_TYPES.put((Object)new ResourceLocation("bone_block"), (Object)SoundType.f_56724_);
        SOUND_TYPES.put((Object)new ResourceLocation("netherite_block"), (Object)SoundType.f_56725_);
        SOUND_TYPES.put((Object)new ResourceLocation("ancient_debris"), (Object)SoundType.f_56726_);
        SOUND_TYPES.put((Object)new ResourceLocation("lodestone"), (Object)SoundType.f_56727_);
        SOUND_TYPES.put((Object)new ResourceLocation("chain"), (Object)SoundType.f_56728_);
        SOUND_TYPES.put((Object)new ResourceLocation("nether_gold_ore"), (Object)SoundType.f_56729_);
        SOUND_TYPES.put((Object)new ResourceLocation("gilded_blackstone"), (Object)SoundType.f_56730_);
        SOUND_TYPES.put((Object)new ResourceLocation("candle"), (Object)SoundType.f_154653_);
        SOUND_TYPES.put((Object)new ResourceLocation("amethyst"), (Object)SoundType.f_154654_);
        SOUND_TYPES.put((Object)new ResourceLocation("amethyst_cluster"), (Object)SoundType.f_154655_);
        SOUND_TYPES.put((Object)new ResourceLocation("small_amethyst_bud"), (Object)SoundType.f_154656_);
        SOUND_TYPES.put((Object)new ResourceLocation("medium_amethyst_bud"), (Object)SoundType.f_154657_);
        SOUND_TYPES.put((Object)new ResourceLocation("large_amethyst_bud"), (Object)SoundType.f_154658_);
        SOUND_TYPES.put((Object)new ResourceLocation("tuff"), (Object)SoundType.f_154659_);
        SOUND_TYPES.put((Object)new ResourceLocation("calcite"), (Object)SoundType.f_154660_);
        SOUND_TYPES.put((Object)new ResourceLocation("dripstone_block"), (Object)SoundType.f_154661_);
        SOUND_TYPES.put((Object)new ResourceLocation("pointed_dripstone"), (Object)SoundType.f_154662_);
        SOUND_TYPES.put((Object)new ResourceLocation("copper"), (Object)SoundType.f_154663_);
        SOUND_TYPES.put((Object)new ResourceLocation("cave_vines"), (Object)SoundType.f_154664_);
        SOUND_TYPES.put((Object)new ResourceLocation("spore_blossom"), (Object)SoundType.f_154665_);
        SOUND_TYPES.put((Object)new ResourceLocation("azalea"), (Object)SoundType.f_154666_);
        SOUND_TYPES.put((Object)new ResourceLocation("flowering_azalea"), (Object)SoundType.f_154667_);
        SOUND_TYPES.put((Object)new ResourceLocation("moss_carpet"), (Object)SoundType.f_154668_);
        SOUND_TYPES.put((Object)new ResourceLocation("pink_petals"), (Object)SoundType.f_271137_);
        SOUND_TYPES.put((Object)new ResourceLocation("moss"), (Object)SoundType.f_154669_);
        SOUND_TYPES.put((Object)new ResourceLocation("big_dripleaf"), (Object)SoundType.f_154670_);
        SOUND_TYPES.put((Object)new ResourceLocation("small_dripleaf"), (Object)SoundType.f_154671_);
        SOUND_TYPES.put((Object)new ResourceLocation("rooted_dirt"), (Object)SoundType.f_154672_);
        SOUND_TYPES.put((Object)new ResourceLocation("hanging_roots"), (Object)SoundType.f_154673_);
        SOUND_TYPES.put((Object)new ResourceLocation("azalea_leaves"), (Object)SoundType.f_154674_);
        SOUND_TYPES.put((Object)new ResourceLocation("sculk_sensor"), (Object)SoundType.f_154675_);
        SOUND_TYPES.put((Object)new ResourceLocation("sculk_catalyst"), (Object)SoundType.f_222472_);
        SOUND_TYPES.put((Object)new ResourceLocation("sculk"), (Object)SoundType.f_222473_);
        SOUND_TYPES.put((Object)new ResourceLocation("sculk_vein"), (Object)SoundType.f_222474_);
        SOUND_TYPES.put((Object)new ResourceLocation("sculk_shrieker"), (Object)SoundType.f_222475_);
        SOUND_TYPES.put((Object)new ResourceLocation("glow_lichen"), (Object)SoundType.f_154676_);
        SOUND_TYPES.put((Object)new ResourceLocation("deepslate"), (Object)SoundType.f_154677_);
        SOUND_TYPES.put((Object)new ResourceLocation("deepslate_bricks"), (Object)SoundType.f_154678_);
        SOUND_TYPES.put((Object)new ResourceLocation("deepslate_tiles"), (Object)SoundType.f_154679_);
        SOUND_TYPES.put((Object)new ResourceLocation("polished_deepslate"), (Object)SoundType.f_154680_);
        SOUND_TYPES.put((Object)new ResourceLocation("froglight"), (Object)SoundType.f_222465_);
        SOUND_TYPES.put((Object)new ResourceLocation("frogspawn"), (Object)SoundType.f_222466_);
        SOUND_TYPES.put((Object)new ResourceLocation("mangrove_roots"), (Object)SoundType.f_222467_);
        SOUND_TYPES.put((Object)new ResourceLocation("muddy_mangrove_roots"), (Object)SoundType.f_222468_);
        SOUND_TYPES.put((Object)new ResourceLocation("mud"), (Object)SoundType.f_222469_);
        SOUND_TYPES.put((Object)new ResourceLocation("mud_bricks"), (Object)SoundType.f_222470_);
        SOUND_TYPES.put((Object)new ResourceLocation("packed_mud"), (Object)SoundType.f_222471_);
        SOUND_TYPES.put((Object)new ResourceLocation("hanging_sign"), (Object)SoundType.f_244174_);
        SOUND_TYPES.put((Object)new ResourceLocation("nether_wood_hanging_sign"), (Object)SoundType.f_256908_);
        SOUND_TYPES.put((Object)new ResourceLocation("bamboo_wood_hanging_sign"), (Object)SoundType.f_256995_);
        SOUND_TYPES.put((Object)new ResourceLocation("bamboo_wood"), (Object)SoundType.f_243772_);
        SOUND_TYPES.put((Object)new ResourceLocation("nether_wood"), (Object)SoundType.f_244244_);
        SOUND_TYPES.put((Object)new ResourceLocation("cherry_wood"), (Object)SoundType.f_271497_);
        SOUND_TYPES.put((Object)new ResourceLocation("cherry_sapling"), (Object)SoundType.f_271370_);
        SOUND_TYPES.put((Object)new ResourceLocation("cherry_leaves"), (Object)SoundType.f_271239_);
        SOUND_TYPES.put((Object)new ResourceLocation("cherry_wood_hanging_sign"), (Object)SoundType.f_271094_);
        SOUND_TYPES.put((Object)new ResourceLocation("chiseled_bookshelf"), (Object)SoundType.f_256956_);
        SOUND_TYPES.put((Object)new ResourceLocation("suspicious_sand"), (Object)SoundType.f_271168_);
        SOUND_TYPES.put((Object)new ResourceLocation("suspicious_gravel"), (Object)SoundType.f_276658_);
        SOUND_TYPES.put((Object)new ResourceLocation("decorated_pot"), (Object)SoundType.f_271215_);
        SOUND_TYPES.put((Object)new ResourceLocation("decorated_pot_cracked"), (Object)SoundType.f_276571_);
        MAP_COLORS.put((Object)"none", (Object)MapColor.f_283808_);
        MAP_COLORS.put((Object)"grass", (Object)MapColor.f_283824_);
        MAP_COLORS.put((Object)"sand", (Object)MapColor.f_283761_);
        MAP_COLORS.put((Object)"wool", (Object)MapColor.f_283930_);
        MAP_COLORS.put((Object)"fire", (Object)MapColor.f_283816_);
        MAP_COLORS.put((Object)"ice", (Object)MapColor.f_283828_);
        MAP_COLORS.put((Object)"metal", (Object)MapColor.f_283906_);
        MAP_COLORS.put((Object)"plant", (Object)MapColor.f_283915_);
        MAP_COLORS.put((Object)"snow", (Object)MapColor.f_283811_);
        MAP_COLORS.put((Object)"clay", (Object)MapColor.f_283744_);
        MAP_COLORS.put((Object)"dirt", (Object)MapColor.f_283762_);
        MAP_COLORS.put((Object)"stone", (Object)MapColor.f_283947_);
        MAP_COLORS.put((Object)"water", (Object)MapColor.f_283864_);
        MAP_COLORS.put((Object)"wood", (Object)MapColor.f_283825_);
        MAP_COLORS.put((Object)"quartz", (Object)MapColor.f_283942_);
        MAP_COLORS.put((Object)"color_orange", (Object)MapColor.f_283750_);
        MAP_COLORS.put((Object)"color_magenta", (Object)MapColor.f_283931_);
        MAP_COLORS.put((Object)"color_light_blue", (Object)MapColor.f_283869_);
        MAP_COLORS.put((Object)"color_yellow", (Object)MapColor.f_283832_);
        MAP_COLORS.put((Object)"color_light_green", (Object)MapColor.f_283916_);
        MAP_COLORS.put((Object)"color_pink", (Object)MapColor.f_283765_);
        MAP_COLORS.put((Object)"color_gray", (Object)MapColor.f_283818_);
        MAP_COLORS.put((Object)"color_light_gray", (Object)MapColor.f_283779_);
        MAP_COLORS.put((Object)"color_cyan", (Object)MapColor.f_283772_);
        MAP_COLORS.put((Object)"color_purple", (Object)MapColor.f_283889_);
        MAP_COLORS.put((Object)"color_blue", (Object)MapColor.f_283743_);
        MAP_COLORS.put((Object)"color_brown", (Object)MapColor.f_283748_);
        MAP_COLORS.put((Object)"color_green", (Object)MapColor.f_283784_);
        MAP_COLORS.put((Object)"color_red", (Object)MapColor.f_283913_);
        MAP_COLORS.put((Object)"color_black", (Object)MapColor.f_283927_);
        MAP_COLORS.put((Object)"gold", (Object)MapColor.f_283757_);
        MAP_COLORS.put((Object)"diamond", (Object)MapColor.f_283821_);
        MAP_COLORS.put((Object)"lapis", (Object)MapColor.f_283933_);
        MAP_COLORS.put((Object)"emerald", (Object)MapColor.f_283812_);
        MAP_COLORS.put((Object)"podzol", (Object)MapColor.f_283819_);
        MAP_COLORS.put((Object)"nether", (Object)MapColor.f_283820_);
        MAP_COLORS.put((Object)"terracotta_white", (Object)MapColor.f_283919_);
        MAP_COLORS.put((Object)"terracotta_orange", (Object)MapColor.f_283895_);
        MAP_COLORS.put((Object)"terracotta_magenta", (Object)MapColor.f_283850_);
        MAP_COLORS.put((Object)"terracotta_light_blue", (Object)MapColor.f_283791_);
        MAP_COLORS.put((Object)"terracotta_yellow", (Object)MapColor.f_283843_);
        MAP_COLORS.put((Object)"terracotta_light_green", (Object)MapColor.f_283778_);
        MAP_COLORS.put((Object)"terracotta_pink", (Object)MapColor.f_283870_);
        MAP_COLORS.put((Object)"terracotta_gray", (Object)MapColor.f_283861_);
        MAP_COLORS.put((Object)"terracotta_light_gray", (Object)MapColor.f_283907_);
        MAP_COLORS.put((Object)"terracotta_cyan", (Object)MapColor.f_283846_);
        MAP_COLORS.put((Object)"terracotta_purple", (Object)MapColor.f_283892_);
        MAP_COLORS.put((Object)"terracotta_blue", (Object)MapColor.f_283908_);
        MAP_COLORS.put((Object)"terracotta_brown", (Object)MapColor.f_283774_);
        MAP_COLORS.put((Object)"terracotta_green", (Object)MapColor.f_283856_);
        MAP_COLORS.put((Object)"terracotta_red", (Object)MapColor.f_283798_);
        MAP_COLORS.put((Object)"terracotta_black", (Object)MapColor.f_283771_);
        MAP_COLORS.put((Object)"crimson_nylium", (Object)MapColor.f_283909_);
        MAP_COLORS.put((Object)"crimson_stem", (Object)MapColor.f_283804_);
        MAP_COLORS.put((Object)"crimson_hyphae", (Object)MapColor.f_283883_);
        MAP_COLORS.put((Object)"warped_nylium", (Object)MapColor.f_283745_);
        MAP_COLORS.put((Object)"warped_stem", (Object)MapColor.f_283749_);
        MAP_COLORS.put((Object)"warped_hyphae", (Object)MapColor.f_283807_);
        MAP_COLORS.put((Object)"warped_wart_block", (Object)MapColor.f_283898_);
        MAP_COLORS.put((Object)"deepslate", (Object)MapColor.f_283875_);
        MAP_COLORS.put((Object)"raw_iron", (Object)MapColor.f_283877_);
        MAP_COLORS.put((Object)"glow_lichen", (Object)MapColor.f_283769_);
        for (NoteBlockInstrument instrument : NoteBlockInstrument.values()) {
            if (!instrument.m_262503_()) continue;
            INSTRUMENTS.put((Object)instrument.m_7912_(), (Object)instrument);
        }
        SENSITIVITIES.put((Object)"everything", (Object)PressurePlateBlock.Sensitivity.EVERYTHING);
        SENSITIVITIES.put((Object)"mobs", (Object)PressurePlateBlock.Sensitivity.MOBS);
    }

    static final class StrictOptionalFieldCodec<A>
    extends MapCodec<Optional<A>> {
        private final String name;
        private final Codec<A> elementCodec;

        public StrictOptionalFieldCodec(String string, Codec<A> codec) {
            this.name = string;
            this.elementCodec = codec;
        }

        public <T> DataResult<Optional<A>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            Object object = mapLike.get(this.name);
            if (object == null) {
                return DataResult.success(Optional.empty());
            }
            return this.elementCodec.parse(dynamicOps, object).map(Optional::of);
        }

        public <T> RecordBuilder<T> encode(Optional<A> optional, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
            if (optional.isPresent()) {
                return recordBuilder.add(this.name, this.elementCodec.encodeStart(dynamicOps, optional.get()));
            }
            return recordBuilder;
        }

        public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
            return Stream.of(dynamicOps.createString(this.name));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof StrictOptionalFieldCodec) {
                StrictOptionalFieldCodec strictOptionalFieldCodec = (StrictOptionalFieldCodec)((Object)object);
                return Objects.equals(this.name, strictOptionalFieldCodec.name) && Objects.equals(this.elementCodec, strictOptionalFieldCodec.elementCodec);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.elementCodec);
        }

        public String toString() {
            return "StrictOptionalFieldCodec[" + this.name + ": " + this.elementCodec + "]";
        }
    }
}

