/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket(value="apply_builder_rule", dir=KiwiPacket.Direction.PLAY_TO_SERVER)
public class CApplyBuilderRulePacket
extends PacketHandler {
    public static CApplyBuilderRulePacket I;

    public static void send(UseOnContext context, KHolder<BuilderRule> holder, List<BlockPos> positions) {
        I.sendToServer(buf -> {
            buf.m_130068_((Enum)context.m_43724_());
            buf.m_130064_(context.m_8083_());
            buf.m_130085_(holder.key());
            buf.m_236828_((Collection)positions, FriendlyByteBuf::m_130064_);
        });
    }

    @Override
    public CompletableFuture<FriendlyByteBuf> receive(Function<Runnable, CompletableFuture<FriendlyByteBuf>> function, FriendlyByteBuf buf, @Nullable ServerPlayer player) {
        Objects.requireNonNull(player);
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        BlockPos pos = buf.m_130135_();
        ResourceLocation ruleId = buf.m_130281_();
        List positions = (List)buf.m_236838_(Lists::newArrayListWithExpectedSize, FriendlyByteBuf::m_130135_);
        if (Stream.concat(Stream.of(pos), positions.stream()).anyMatch($ -> !player.m_9236_().m_46749_($))) {
            return null;
        }
        return function.apply(() -> {
            BlockHitResult blockHitResult;
            BuilderRule rule = BuilderRules.get(ruleId);
            if (rule == null) {
                return;
            }
            HitResult hitResult = player.m_19907_(10.0, 1.0f, false);
            if (!(hitResult instanceof BlockHitResult) || !(blockHitResult = (BlockHitResult)hitResult).m_82425_().equals((Object)pos)) {
                return;
            }
            BlockState blockState = player.m_9236_().m_8055_(pos);
            Block block = blockState.m_60734_();
            if (rule.relatedBlocks().noneMatch(block::equals)) {
                return;
            }
            UseOnContext context = new UseOnContext((Player)player, hand, blockHitResult);
            if (rule.matches((Player)player, context.m_43722_(), blockState)) {
                rule.apply(context, positions);
            }
        });
    }
}

