/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.item.ModItem;

public final class TooltipEvents {
    public static final String disableDebugTooltipCommand = "@kiwi disable debugTooltip";
    private static final DebugTooltipCache cache = new DebugTooltipCache();
    private static boolean firstSeenDebugTooltip = true;
    private static long latestPressF3;
    private static boolean holdAlt;
    private static long holdAltStart;
    private static boolean showTagsBeforeAlt;

    private TooltipEvents() {
    }

    public static void globalTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flag);
        }
    }

    public static void debugTooltip(ItemStack itemStack, List<Component> tooltip, TooltipFlag flag) {
        if (!flag.m_7050_()) {
            return;
        }
        CompoundTag nbt = itemStack.m_41783_();
        Minecraft mc = Minecraft.m_91087_();
        long millis = Util.m_137550_();
        if (KiwiClientConfig.f3CopyInInventory && mc.f_91074_ != null && millis - latestPressF3 > 500L && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292)) {
            latestPressF3 = millis;
            MutableComponent component = Component.m_237113_((String)BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).toString());
            mc.f_91068_.m_90911_(component.getString());
            if (nbt != null) {
                component.m_7220_(NbtUtils.m_178061_((Tag)nbt));
            }
            component.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, component.getString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))).m_131138_(component.getString()));
            mc.f_91074_.m_5661_((Component)component, false);
        }
        if (KiwiClientConfig.nbtTooltip && Screen.m_96638_() && nbt != null) {
            TooltipEvents.trySendTipMsg(mc);
            tooltip.removeIf(c -> c.m_214077_() instanceof TranslatableContents && "item.nbt_tags".equals(((TranslatableContents)c.m_214077_()).m_237508_()));
            if (TooltipEvents.cache.nbt != nbt) {
                TooltipEvents.cache.nbt = nbt;
                TooltipEvents.cache.formattedNbt = NbtUtils.m_178061_((Tag)TooltipEvents.cache.nbt);
            }
            tooltip.add(TooltipEvents.cache.formattedNbt);
        } else if (KiwiClientConfig.tagsTooltip) {
            cache.maybeUpdateTags(itemStack);
            boolean alt = Screen.m_96639_();
            if (!holdAlt && alt) {
                holdAltStart = millis;
                showTagsBeforeAlt = TooltipEvents.cache.showTags;
            } else if (holdAlt && !alt && TooltipEvents.cache.showTags && millis - holdAltStart < 500L) {
                TooltipEvents.cache.pageNow = TooltipEvents.cache.pageNow + (Screen.m_96637_() ? -1 : 1);
                TooltipEvents.cache.needUpdatePreferredType = true;
            }
            if (alt && millis - holdAltStart >= 500L) {
                TooltipEvents.cache.showTags = !showTagsBeforeAlt;
                TooltipEvents.cache.lastShowTags = millis;
            }
            holdAlt = alt;
            if (!TooltipEvents.cache.pages.isEmpty()) {
                TooltipEvents.trySendTipMsg(mc);
                cache.appendTagsTooltip(tooltip);
            }
        }
    }

    private static void trySendTipMsg(Minecraft mc) {
        if (firstSeenDebugTooltip && mc.f_91074_ != null) {
            firstSeenDebugTooltip = false;
            if (KiwiClientConfig.debugTooltipMsg) {
                MutableComponent clickHere = Component.m_237115_((String)"tip.kiwi.click_here").m_130938_($ -> $.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, disableDebugTooltipCommand)));
                mc.f_91074_.m_213846_((Component)Component.m_237110_((String)"tip.kiwi.debug_tooltip", (Object[])new Object[]{clickHere.m_130940_(ChatFormatting.AQUA)}));
                KiwiClientConfig.debugTooltipMsg = false;
                KiwiConfigManager.getHandler(KiwiClientConfig.class).save();
            }
        }
    }

    private static class DebugTooltipCache {
        private final List<String> pageTypes = Lists.newArrayList();
        private final List<List<String>> pages = Lists.newArrayList();
        private int pageNow = 0;
        private ItemStack itemStack = ItemStack.f_41583_;
        private CompoundTag nbt;
        private Component formattedNbt;
        private boolean showTags;
        private long lastShowTags;
        private String preferredType;
        public boolean needUpdatePreferredType;

        private DebugTooltipCache() {
        }

        public void maybeUpdateTags(ItemStack itemStack) {
            if (this.itemStack == itemStack) {
                return;
            }
            this.itemStack = itemStack;
            this.pages.clear();
            this.pageTypes.clear();
            this.pageNow = 0;
            this.addPages("item", itemStack.m_204131_().map(TagKey::f_203868_));
            Item item = itemStack.m_41720_();
            Block block = Block.m_49814_((Item)item);
            if (block != Blocks.f_50016_) {
                this.addPages("block", DebugTooltipCache.getTags(BuiltInRegistries.f_256975_, block));
            }
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                EntityType type = spawnEggItem.m_43228_(itemStack.m_41783_());
                this.addPages("entity_type", DebugTooltipCache.getTags(BuiltInRegistries.f_256780_, type));
            } else if (item instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                this.addPages("fluid", DebugTooltipCache.getTags(BuiltInRegistries.f_257020_, bucketItem.getFluid()));
            }
            for (int i = 0; i < this.pages.size(); ++i) {
                if (!this.pageTypes.get(i).equals(this.preferredType)) continue;
                this.pageNow = i;
                break;
            }
        }

        private static <T> Stream<ResourceLocation> getTags(Registry<T> registry, T object) {
            return registry.m_7854_(object).flatMap(arg_0 -> registry.m_203636_(arg_0)).stream().flatMap(Holder::m_203616_).map(TagKey::f_203868_);
        }

        public void addPages(String type, Stream<ResourceLocation> stream) {
            List<String> tags = stream.map(Object::toString).sorted().toList();
            if (tags.isEmpty()) {
                return;
            }
            int i = 0;
            ArrayList page = Lists.newArrayList();
            for (String tag : tags) {
                page.add("#" + tag);
                if (++i != KiwiClientConfig.tagsTooltipTagsPerPage) continue;
                this.pages.add(page);
                this.pageTypes.add(type);
                page = Lists.newArrayList();
                i = 0;
            }
            if (!page.isEmpty()) {
                this.pages.add(page);
                this.pageTypes.add(type);
            }
        }

        public void appendTagsTooltip(List<Component> tooltip) {
            if (this.pages.isEmpty()) {
                return;
            }
            if (this.showTags && Util.m_137550_() - this.lastShowTags > 60000L) {
                this.showTags = false;
            }
            if (!this.showTags) {
                if (KiwiClientConfig.tagsTooltipAppendKeybindHint) {
                    this.findIdLine(tooltip, i -> tooltip.set(i, (Component)((Component)tooltip.get(i)).m_6881_().m_130946_(" (alt)")));
                }
                return;
            }
            this.lastShowTags = Util.m_137550_();
            ArrayList sub = Lists.newArrayList();
            this.pageNow = Math.floorMod(this.pageNow, this.pages.size());
            if (this.needUpdatePreferredType) {
                this.needUpdatePreferredType = false;
                this.preferredType = this.pageTypes.get(this.pageNow);
            }
            List<String> page = this.pages.get(this.pageNow);
            for (String tag : page) {
                sub.add(Component.m_237113_((String)tag).m_130940_(ChatFormatting.DARK_GRAY));
            }
            int index = this.findIdLine(tooltip, i -> {
                String type = this.pageTypes.get(this.pageNow);
                tooltip.set(i, (Component)((Component)tooltip.get(i)).m_6881_().m_130946_(" (%s/%s...%s)".formatted(this.pageNow + 1, this.pages.size(), type)));
            });
            index = index == -1 ? tooltip.size() : index + 1;
            tooltip.addAll(index, sub);
        }

        private int findIdLine(List<Component> tooltip, IntConsumer consumer) {
            String id = BuiltInRegistries.f_257033_.m_7981_((Object)this.itemStack.m_41720_()).toString();
            for (int i = 0; i < tooltip.size(); ++i) {
                Component component = tooltip.get(i);
                if (!component.getString().equals(id)) continue;
                consumer.accept(i);
                return i;
            }
            return -1;
        }
    }
}

