/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.fluid;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.AbstractFluidPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPortHandler;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidPortHandlerForge<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>>
extends AbstractFluidPortHandler<Controller, T>
implements IFluidHandler {
    public static Capability<IFluidHandler> CAPAP_FORGE_FLUIDHANDLER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFluidHandler>(){});
    private IFluidHandler _consumer = null;
    private final FluidHandlerForwarder _capabilityForwarder;
    private final LazyOptional<IFluidHandler> _capability = LazyOptional.of(() -> this);

    public FluidPortHandlerForge(T part, IoMode mode) {
        super(part, mode);
        this._capabilityForwarder = new FluidHandlerForwarder((IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    @Override
    public int outputFluid(FluidStack stack) {
        if (null == this._consumer || this.isPassive() || ((IIoEntity)this.getIoEntity()).getIoDirection().isInput()) {
            return 0;
        }
        return this._consumer.fill(stack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public int inputFluid(IFluidHandler destination, int maxAmount) {
        if (null == this._consumer || this.isPassive() || ((IIoEntity)this.getIoEntity()).getIoDirection().isOutput()) {
            return 0;
        }
        FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)this._consumer, (int)maxAmount, (boolean)true);
        return transferred.isEmpty() ? 0 : transferred.getAmount();
    }

    @Override
    public boolean isConnected() {
        return null != this._consumer;
    }

    @Override
    public void checkConnections(@Nullable Level world, BlockPos position) {
        this._consumer = this.lookupConsumer(world, position, CAPAP_FORGE_FLUIDHANDLER, (NonNullPredicate<BlockEntity>)((NonNullPredicate)te -> te instanceof IFluidPortHandler), this._consumer);
    }

    @Nullable
    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction direction) {
        if (CAPAP_FORGE_FLUIDHANDLER == capability) {
            return this._capability.cast();
        }
        return null;
    }

    @Override
    public void invalidate() {
        this._capability.invalidate();
    }

    @Override
    public void update(NonNullFunction<IoDirection, IFluidHandler> handlerProvider) {
        this._capabilityForwarder.setHandler((IFluidHandler)handlerProvider.apply((Object)((IIoEntity)this.getIoEntity()).getIoDirection()));
    }

    public int getTanks() {
        return this._capabilityForwarder.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this._capabilityForwarder.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this._capabilityForwarder.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this._capabilityForwarder.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.fill(resource, action) : 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.drain(resource, action) : FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.drain(maxDrain, action) : FluidStack.EMPTY;
    }
}

