/*
 * Decompiled with CFR 0.152.
 */
package cofh.toolscomplement.init.registries;

import cofh.core.common.item.ArmorItemCoFH;
import cofh.core.common.item.ExcavatorItem;
import cofh.core.common.item.HammerItem;
import cofh.core.common.item.KnifeItem;
import cofh.core.common.item.SickleItem;
import cofh.lib.common.item.ArmorMaterialCoFH;
import cofh.lib.common.item.AxeItemCoFH;
import cofh.lib.common.item.HoeItemCoFH;
import cofh.lib.common.item.ItemTierCoFH;
import cofh.lib.common.item.PickaxeItemCoFH;
import cofh.lib.common.item.ShovelItemCoFH;
import cofh.lib.common.item.SwordItemCoFH;
import cofh.lib.init.tags.ItemTagsCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.toolscomplement.ToolsComplement;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static LinkedHashSet<RegistryObject<Item>> CREATIVE_TAB_ITEMS = Sets.newLinkedHashSet();
    public static final Tier TOOL_MATERIAL_COPPER = new ItemTierCoFH(1, 160, 4.5f, 1.5f, 9, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER));
    public static final Tier TOOL_MATERIAL_TIN = new ItemTierCoFH(0, 16, 13.0f, 0.0f, 18, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_TIN));
    public static final Tier TOOL_MATERIAL_LEAD = new ItemTierCoFH(1, 32, 12.0f, 1.0f, 16, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_LEAD));
    public static final Tier TOOL_MATERIAL_SILVER = new ItemTierCoFH(0, 24, 14.0f, 0.0f, 30, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_SILVER));
    public static final Tier TOOL_MATERIAL_NICKEL = new ItemTierCoFH(2, 225, 7.0f, 2.5f, 12, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_NICKEL));
    public static final Tier TOOL_MATERIAL_BRONZE = new ItemTierCoFH(2, 325, 5.5f, 2.0f, 16, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_BRONZE));
    public static final Tier TOOL_MATERIAL_ELECTRUM = new ItemTierCoFH(0, 96, 13.0f, 0.0f, 28, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_ELECTRUM));
    public static final Tier TOOL_MATERIAL_INVAR = new ItemTierCoFH(2, 300, 7.0f, 2.5f, 13, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_INVAR));
    public static final Tier TOOL_MATERIAL_CONSTANTAN = new ItemTierCoFH(1, 250, 5.5f, 2.0f, 10, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_CONSTANTAN));
    public static ArmorMaterialCoFH armorMaterialCopper;
    public static ArmorMaterialCoFH armorMaterialTin;
    public static ArmorMaterialCoFH armorMaterialLead;
    public static ArmorMaterialCoFH armorMaterialSilver;
    public static ArmorMaterialCoFH armorMaterialNickel;
    public static ArmorMaterialCoFH armorMaterialBronze;
    public static ArmorMaterialCoFH armorMaterialElectrum;
    public static ArmorMaterialCoFH armorMaterialInvar;
    public static ArmorMaterialCoFH armorMaterialConstantan;

    private ModItems() {
    }

    public static RegistryObject<Item> registerWithTab(String name, Supplier<Item> supplier) {
        RegistryObject reg = ToolsComplement.ITEMS.register(name, supplier);
        CREATIVE_TAB_ITEMS.add((RegistryObject<Item>)reg);
        return reg;
    }

    public static void register() {
        armorMaterialCopper = new ArmorMaterialCoFH("tools_complement:copper", 7, new int[]{1, 3, 4, 1}, 11, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER));
        armorMaterialTin = new ArmorMaterialCoFH("tools_complement:tin", 8, new int[]{1, 3, 4, 1}, 20, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_TIN));
        armorMaterialLead = new ArmorMaterialCoFH("tools_complement:lead", 12, new int[]{2, 4, 5, 2}, 18, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_LEAD));
        armorMaterialSilver = new ArmorMaterialCoFH("tools_complement:silver", 6, new int[]{1, 3, 5, 2}, 32, SoundEvents.f_11676_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_SILVER));
        armorMaterialNickel = new ArmorMaterialCoFH("tools_complement:nickel", 14, new int[]{2, 5, 5, 2}, 14, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_NICKEL));
        armorMaterialBronze = new ArmorMaterialCoFH("tools_complement:bronze", 16, new int[]{2, 5, 6, 2}, 18, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_BRONZE));
        armorMaterialElectrum = new ArmorMaterialCoFH("tools_complement:electrum", 7, new int[]{1, 3, 5, 2}, 30, SoundEvents.f_11676_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_ELECTRUM));
        armorMaterialInvar = new ArmorMaterialCoFH("tools_complement:invar", 15, new int[]{2, 5, 7, 2}, 15, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_INVAR));
        armorMaterialConstantan = new ArmorMaterialCoFH("tools_complement:constantan", 8, new int[]{1, 4, 4, 2}, 12, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_CONSTANTAN));
        ModItems.registerExtraToolSet("iron", (Tier)Tiers.IRON);
        ModItems.registerExtraToolSet("gold", (Tier)Tiers.GOLD);
        ModItems.registerExtraToolSet("diamond", (Tier)Tiers.DIAMOND);
        ModItems.registerExtraToolSet("netherite", (Tier)Tiers.NETHERITE);
        ModItems.registerFullToolSet("copper", TOOL_MATERIAL_COPPER);
        ModItems.registerFullToolSet("tin", TOOL_MATERIAL_TIN);
        ModItems.registerFullToolSet("lead", TOOL_MATERIAL_LEAD);
        ModItems.registerFullToolSet("silver", TOOL_MATERIAL_SILVER);
        ModItems.registerFullToolSet("nickel", TOOL_MATERIAL_NICKEL);
        ModItems.registerFullToolSet("bronze", TOOL_MATERIAL_BRONZE);
        ModItems.registerFullToolSet("electrum", TOOL_MATERIAL_ELECTRUM);
        ModItems.registerFullToolSet("invar", TOOL_MATERIAL_INVAR);
        ModItems.registerFullToolSet("constantan", TOOL_MATERIAL_CONSTANTAN);
        ModItems.registerArmorSet("copper", (ArmorMaterial)armorMaterialCopper);
        ModItems.registerArmorSet("tin", (ArmorMaterial)armorMaterialTin);
        ModItems.registerArmorSet("lead", (ArmorMaterial)armorMaterialLead);
        ModItems.registerArmorSet("silver", (ArmorMaterial)armorMaterialSilver);
        ModItems.registerArmorSet("nickel", (ArmorMaterial)armorMaterialNickel);
        ModItems.registerArmorSet("bronze", (ArmorMaterial)armorMaterialBronze);
        ModItems.registerArmorSet("electrum", (ArmorMaterial)armorMaterialElectrum);
        ModItems.registerArmorSet("invar", (ArmorMaterial)armorMaterialInvar);
        ModItems.registerArmorSet("constantan", (ArmorMaterial)armorMaterialConstantan);
    }

    private static void registerFullToolSet(String prefix, Tier tier) {
        ModItems.registerStandardToolSet(prefix, tier);
        ModItems.registerExtraToolSet(prefix, tier);
    }

    private static void registerStandardToolSet(String prefix, Tier tier) {
        ModItems.registerWithTab(prefix + "_shovel", () -> new ShovelItemCoFH(tier, 1.5f, -3.0f, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_pickaxe", () -> new PickaxeItemCoFH(tier, 1, -2.8f, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_axe", () -> new AxeItemCoFH(tier, tier.m_6631_() > 0.0f ? 8.0f - tier.m_6631_() : 6.0f, MathHelper.clamp((float)(-3.7f + tier.m_6624_() / 10.0f), (float)-3.2f, (float)-3.0f), Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_hoe", () -> new HoeItemCoFH(tier, -tier.m_6604_(), Math.min(-3.0f + (float)tier.m_6604_(), 0.0f), Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_sword", () -> new SwordItemCoFH(tier, 3, -2.4f, Utils.itemProperties()));
    }

    private static void registerExtraToolSet(String prefix, Tier tier) {
        ModItems.registerWithTab(prefix + "_excavator", () -> new ExcavatorItem(tier, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_hammer", () -> new HammerItem(tier, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_sickle", () -> new SickleItem(tier, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_knife", () -> new KnifeItem(tier, Utils.itemProperties()));
    }

    private static void registerArmorSet(String prefix, ArmorMaterial material) {
        ModItems.registerWithTab(prefix + "_helmet", () -> new ArmorItemCoFH(material, ArmorItem.Type.HELMET, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_chestplate", () -> new ArmorItemCoFH(material, ArmorItem.Type.CHESTPLATE, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_leggings", () -> new ArmorItemCoFH(material, ArmorItem.Type.LEGGINGS, Utils.itemProperties()));
        ModItems.registerWithTab(prefix + "_boots", () -> new ArmorItemCoFH(material, ArmorItem.Type.BOOTS, Utils.itemProperties()));
    }
}

