/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.block.MysticalCropBlock;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    private static final ResourceLocation CROP_PROVIDER = new ResourceLocation("mysticalagriculture", "crop");
    private static final ResourceLocation INFERIUM_CROP_PROVIDER = new ResourceLocation("mysticalagriculture", "inferium_crop");
    private static final ResourceLocation INFUSED_FARMLAND_PROVIDER = new ResourceLocation("mysticalagriculture", "infused_farmland");

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                Set<ResourceLocation> biomes;
                Block crux;
                double secondaryChance;
                Block block = accessor.getBlock();
                Crop crop = ((ICropProvider)block).getCrop();
                tooltip.add((Component)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
                BlockPos pos = accessor.getPosition();
                BlockPos downPos = pos.m_7495_();
                Level level = accessor.getLevel();
                Block belowBlock = level.m_8055_(downPos).m_60734_();
                if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && (secondaryChance = crop.getSecondaryChance(belowBlock)) > 0.0) {
                    MutableComponent chanceText = Component.m_237113_((String)String.valueOf((int)(secondaryChance * 100.0))).m_130946_("%").m_130940_(crop.getTier().getTextColor());
                    tooltip.add((Component)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
                }
                if ((crux = crop.getCruxBlock()) != null) {
                    ItemStack stack = new ItemStack((ItemLike)crux);
                    tooltip.add((Component)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack.m_41786_()}).build());
                }
                if (!(biomes = crop.getRequiredBiomes()).isEmpty()) {
                    Holder biome = level.m_204166_(pos);
                    if (biomes.stream().noneMatch(arg_0 -> ((Holder)biome).m_203373_(arg_0))) {
                        tooltip.add((Component)ModTooltips.INVALID_BIOME.color(ChatFormatting.RED).build());
                    }
                }
            }

            public ResourceLocation getUid() {
                return CROP_PROVIDER;
            }
        }, MysticalCropBlock.class);
        registration.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                Block block = accessor.getBlock();
                Crop crop = ((ICropProvider)block).getCrop();
                BlockPos downPos = accessor.getPosition().m_7495_();
                Block belowBlock = accessor.getLevel().m_8055_(downPos).m_60734_();
                int output = 100;
                if (belowBlock instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)belowBlock;
                    int tier = farmland.getTier().getValue();
                    output = tier * 50 + 50;
                }
                MutableComponent inferiumOutputText = Component.m_237113_((String)String.valueOf(output)).m_130946_("%").m_130940_(crop.getTier().getTextColor());
                tooltip.add((Component)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
            }

            public ResourceLocation getUid() {
                return INFERIUM_CROP_PROVIDER;
            }
        }, InferiumCropBlock.class);
        registration.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                Block block = accessor.getBlock();
                IEssenceFarmland farmland = (IEssenceFarmland)block;
                tooltip.add((Component)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
            }

            public ResourceLocation getUid() {
                return INFUSED_FARMLAND_PROVIDER;
            }
        }, InfusedFarmlandBlock.class);
    }
}

