/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsstorage.storage.StorageEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class StorageHolder
extends AbstractWorldData<StorageHolder> {
    public static final String NAME = "RFToolsStorageHolder";
    private final Map<UUID, StorageEntry> storageEntryMap = new HashMap<UUID, StorageEntry>();

    private StorageHolder() {
    }

    private StorageHolder(CompoundTag tag) {
        ListTag storages = tag.m_128437_("Storages", 10);
        for (Tag storage : storages) {
            StorageEntry entry = new StorageEntry((CompoundTag)storage);
            this.storageEntryMap.put(entry.getUuid(), entry);
        }
    }

    public static StorageHolder get(Level world) {
        return (StorageHolder)StorageHolder.getData((Level)world, StorageHolder::new, StorageHolder::new, (String)NAME);
    }

    public StorageEntry getOrCreateStorageEntry(UUID uuid, int size, String createdBy) {
        if (!this.storageEntryMap.containsKey(uuid)) {
            StorageEntry entry = new StorageEntry(size, uuid, createdBy);
            this.storageEntryMap.put(uuid, entry);
            this.save();
        } else {
            StorageEntry entry = this.storageEntryMap.get(uuid);
            if (size != entry.getStacks().size()) {
                entry.resize(size, createdBy);
            }
        }
        return this.storageEntryMap.get(uuid);
    }

    public StorageEntry getStorageEntry(UUID uuid) {
        return this.storageEntryMap.get(uuid);
    }

    public Collection<StorageEntry> getStorages() {
        return this.storageEntryMap.values();
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        ListTag storages = new ListTag();
        for (Map.Entry<UUID, StorageEntry> entry : this.storageEntryMap.entrySet()) {
            storages.add((Object)entry.getValue().write());
        }
        nbt.m_128365_("Storages", (Tag)storages);
        return nbt;
    }
}

