/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.recipe.GatherMicroblockConversionRecipesEvent;
import org.zeith.multipart.microblocks.api.recipe.MicroblockConversionRecipe;
import org.zeith.multipart.microblocks.api.recipe.MicroblockedStack;
import org.zeith.multipart.microblocks.contents.items.ItemMicroblock;
import org.zeith.multipart.microblocks.contents.items.ItemSaw;
import org.zeith.multipart.microblocks.contents.microblocks.PlanarMicroblockType;
import org.zeith.multipart.microblocks.init.ItemsHM;
import org.zeith.multipart.microblocks.init.MicroblockTypesHM;
import org.zeith.multipart.microblocks.init.RecipeSerializersHM;

public class RecipeCutMicroblock
implements CraftingRecipe {
    protected final List<MicroblockConversionRecipe> conversions = GatherMicroblockConversionRecipesEvent.get();
    protected final ResourceLocation id;

    public RecipeCutMicroblock(ResourceLocation id) {
        this.id = id;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return !this.assemble(inv, worldIn.m_9598_()).m_41619_();
    }

    public boolean m_271738_() {
        return false;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        int sawX = -1;
        int sawY = -1;
        ItemStack saw = ItemStack.f_41583_;
        ItemSaw sawItem = null;
        int w = inv.m_39347_();
        int h = inv.m_39346_();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                Item item;
                ItemStack item2 = inv.m_8020_(x + y * w).m_255036_(1);
                if (item2.m_41619_() || !((item = item2.m_41720_()) instanceof ItemSaw)) continue;
                ItemSaw si = (ItemSaw)item;
                if (!saw.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                sawItem = si;
                saw = item2;
                sawX = x;
                sawY = y;
            }
        }
        if (saw.m_41619_() || sawItem == null) {
            return ItemStack.f_41583_;
        }
        ArrayList inputs = Lists.newArrayList();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                ItemStack item = inv.m_8020_(x + y * w).m_255036_(1);
                if (item.m_41619_() || item.m_41720_() instanceof ItemSaw) continue;
                MicroblockedStack st = this.getStackFrom(item, x - sawX, y - sawY);
                if (st == null || !inputs.isEmpty() && !((MicroblockedStack)inputs.get(0)).sameState(st)) {
                    return ItemStack.f_41583_;
                }
                inputs.add(st);
            }
        }
        if (inputs.isEmpty()) {
            return ItemStack.f_41583_;
        }
        BlockState theState = ((MicroblockedStack)inputs.get(0)).state();
        if (!TierSortingRegistry.isCorrectTierForDrops((Tier)sawItem.m_43314_(), (BlockState)theState)) {
            return ItemStack.f_41583_;
        }
        for (MicroblockConversionRecipe conversion : this.conversions) {
            if (!conversion.matches(inputs)) continue;
            return ItemsHM.MICROBLOCK.forItem(conversion.output(), ((MicroblockedStack)inputs.get(0)).stateAsItem(), conversion.count(), false);
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public MicroblockedStack getStackFrom(ItemStack cutStack, int relX, int relY) {
        Item item = cutStack.m_41720_();
        if (item instanceof ItemMicroblock) {
            ItemMicroblock imc = (ItemMicroblock)item;
            BlockState theState = imc.getMicroblockMaterialState(cutStack);
            MicroblockType theType = imc.getMicroblockType(cutStack);
            if (theState == null || theType == null) {
                return null;
            }
            return new MicroblockedStack(relX, relY, false, Optional.of(theType), theState, imc.getMicroblockMaterialStack(cutStack));
        }
        PlanarMicroblockType theType = MicroblockTypesHM.SLAB;
        ItemStack mcb = ItemsHM.MICROBLOCK.forItem(theType, cutStack, false);
        if (mcb.m_41619_()) {
            return null;
        }
        BlockState theState = ItemsHM.MICROBLOCK.getMicroblockMaterialState(mcb);
        if (theState == null) {
            return null;
        }
        return new MicroblockedStack(relX, relY, true, Optional.empty(), theState, cutStack.m_255036_(1));
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializersHM.MICROBLOCK_CUTTING_SERIALIZER;
    }

    public static class SimpleSerializer
    implements RecipeSerializer<RecipeCutMicroblock> {
        public RecipeCutMicroblock fromJson(ResourceLocation id, JsonObject p_44104_) {
            return new RecipeCutMicroblock(id);
        }

        @Nullable
        public RecipeCutMicroblock fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            return new RecipeCutMicroblock(id);
        }

        public void toNetwork(FriendlyByteBuf buf, RecipeCutMicroblock recipe) {
        }
    }
}

