/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.multipart.placements;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public enum CubeConfiguration {
    XN_YN_ZN(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE),
    XN_YN_ZP(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE),
    XN_YP_ZN(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE),
    XN_YP_ZP(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE),
    XP_YN_ZN(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE),
    XP_YN_ZP(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE),
    XP_YP_ZN(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE),
    XP_YP_ZP(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE);

    private final Direction.AxisDirection x;
    private final Direction.AxisDirection y;
    private final Direction.AxisDirection z;
    public static final List<CubeConfiguration> CONFIGS;

    private CubeConfiguration(Direction.AxisDirection x, Direction.AxisDirection y, Direction.AxisDirection z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CubeConfiguration opposite(Direction.Axis axis) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case XN_YN_ZN -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XP_YN_ZN;
                    }
                    case Y: {
                        yield XN_YP_ZN;
                    }
                    case Z: 
                }
                yield XN_YN_ZP;
            }
            case XN_YN_ZP -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XP_YN_ZP;
                    }
                    case Y: {
                        yield XN_YP_ZP;
                    }
                    case Z: 
                }
                yield XN_YN_ZN;
            }
            case XN_YP_ZN -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XP_YP_ZN;
                    }
                    case Y: {
                        yield XN_YN_ZN;
                    }
                    case Z: 
                }
                yield XN_YP_ZP;
            }
            case XN_YP_ZP -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XP_YP_ZP;
                    }
                    case Y: {
                        yield XN_YN_ZP;
                    }
                    case Z: 
                }
                yield XN_YP_ZN;
            }
            case XP_YN_ZN -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XN_YN_ZN;
                    }
                    case Y: {
                        yield XP_YP_ZN;
                    }
                    case Z: 
                }
                yield XP_YN_ZP;
            }
            case XP_YN_ZP -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XN_YN_ZP;
                    }
                    case Y: {
                        yield XP_YP_ZP;
                    }
                    case Z: 
                }
                yield XP_YN_ZN;
            }
            case XP_YP_ZN -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XN_YP_ZN;
                    }
                    case Y: {
                        yield XP_YN_ZN;
                    }
                    case Z: 
                }
                yield XP_YP_ZP;
            }
            case XP_YP_ZP -> {
                switch (axis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield XN_YP_ZP;
                    }
                    case Y: {
                        yield XP_YN_ZP;
                    }
                    case Z: 
                }
                yield XP_YP_ZN;
            }
        };
    }

    public Direction.AxisDirection of(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.x;
            case Direction.Axis.Y -> this.y;
            case Direction.Axis.Z -> this.z;
        };
    }

    public boolean positiveX() {
        return this.x == Direction.AxisDirection.POSITIVE;
    }

    public boolean positiveY() {
        return this.y == Direction.AxisDirection.POSITIVE;
    }

    public boolean positiveZ() {
        return this.z == Direction.AxisDirection.POSITIVE;
    }

    public double xMin(double thickness) {
        return this.positiveX() ? 0.0 : 1.0 - thickness;
    }

    public double yMin(double thickness) {
        return this.positiveY() ? 0.0 : 1.0 - thickness;
    }

    public double zMin(double thickness) {
        return this.positiveZ() ? 0.0 : 1.0 - thickness;
    }

    public double xMax(double thickness) {
        return this.positiveX() ? thickness : 1.0;
    }

    public double yMax(double thickness) {
        return this.positiveY() ? thickness : 1.0;
    }

    public double zMax(double thickness) {
        return this.positiveZ() ? thickness : 1.0;
    }

    public VoxelShape cube(double thickness) {
        return Shapes.m_83048_((double)this.xMin(thickness), (double)this.yMin(thickness), (double)this.zMin(thickness), (double)this.xMax(thickness), (double)this.yMax(thickness), (double)this.zMax(thickness));
    }

    static {
        CONFIGS = List.of(XN_YN_ZN, XN_YN_ZP, XN_YP_ZN, XN_YP_ZP, XP_YN_ZN, XP_YN_ZP, XP_YP_ZN, XP_YP_ZP);
    }
}

