/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.multipart.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.multipart.api.IndexedVoxelShape;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.WorldPartComponents;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PartPos;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;
import org.zeith.multipart.microblocks.api.tile.MicroblockState;
import org.zeith.multipart.microblocks.init.MicroblockTypesHM;

public class MicroblockEntity
extends PartEntity {
    @NBTSerializable(value="State")
    public final MicroblockState state = new MicroblockState();
    public static final ThreadLocal<PartPos> queryMicroblock = ThreadLocal.withInitial(Cast.constant(null));

    public MicroblockEntity(PartDefinition definition, PartContainer container, PartPlacement placement) {
        super(definition, container, placement);
    }

    public MicroblockEntity initState(MicroblockState state) {
        this.state.copyFrom(state);
        this.syncDirty = true;
        this.container.causeBlockUpdate = true;
        return this;
    }

    public BlockState getAppearance(BlockState state, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        PartContainer pc = queryPos != null ? WorldPartComponents.getContainer((BlockGetter)this.container().level(), (BlockPos)queryPos) : null;
        MicroblockPlacementGrid grid = this.state.getType().getPlacementGrid();
        return grid.getAppearance(this, this.placement(), side, queryState, queryPos, pc, queryMicroblock.get());
    }

    public ItemStack getCloneItemStack(BlockHitResult target, Player player, IndexedVoxelShape selection) {
        return this.state.asStack();
    }

    public List<ItemStack> getDrops(@Nullable ServerPlayer harvester, LootParams.Builder context) {
        return List.of(this.state.asStack());
    }

    protected VoxelShape updateShape() {
        if (!this.state.isValid() && this.state.getType() == null) {
            this.state.setType(MicroblockTypesHM.FACADE, this.state.getData());
        }
        return this.state.getType().getShape(this.placement, this.state.getData());
    }

    public VoxelShape getPartOccupiedShapeWith(PartEntity toBePlaced, VoxelShape shapeOfEntity) {
        if (toBePlaced instanceof MicroblockEntity) {
            MicroblockEntity mbe = (MicroblockEntity)toBePlaced;
            return this.state.getType().getOccupationShapeFor(this.placement, mbe.state.getType(), mbe.placement(), mbe, this.state.getData());
        }
        return this.getShape();
    }

    @Nullable
    public BlockState getHardnessState() {
        return this.state.asBlockState();
    }

    public boolean isCorrectToolForDrops(@NotNull Player player) {
        return this.canHarvestPart(player);
    }

    public boolean canHarvestPart(Player player) {
        return ForgeHooks.isCorrectToolForDrops((BlockState)this.state.asBlockState(), (Player)player);
    }

    public float getDestroySpeed(Player player) {
        return this.state.asBlockState().m_60800_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_);
    }

    public boolean isViewBlocking() {
        return this.state.asBlockState().m_60831_((BlockGetter)this.container.level(), this.container.pos());
    }

    public SoundType getSoundType() {
        return this.state.asBlockState().m_60827_();
    }
}

