/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.microblocks;

import java.util.List;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.init.PartPlacementsHM;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.grids.CubicPlacementGrid;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;
import org.zeith.multipart.microblocks.contents.multipart.placements.CubeConfiguration;
import org.zeith.multipart.microblocks.contents.multipart.placements.CubicPartPlacement;

public class CubicMicroblockType
extends MicroblockType {
    protected final List<List<AABB>> boxes;
    protected final List<VoxelShape> shapes;
    protected final List<AABB> itemBoxes;
    public final double thickness;

    public CubicMicroblockType(float thickness) {
        this.thickness = (double)thickness / 16.0;
        this.itemRenderPlacement = PartPlacementsHM.CENTER;
        this.itemBoxes = List.of(new AABB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5).m_82400_(this.thickness / 2.0));
        this.boxes = this.createAABBs();
        this.shapes = this.createShapes();
    }

    protected List<VoxelShape> createShapes() {
        return CubeConfiguration.CONFIGS.stream().map(c -> c.cube(this.thickness)).toList();
    }

    protected List<List<AABB>> createAABBs() {
        return this.createShapes().stream().map(VoxelShape::m_83299_).toList();
    }

    @Override
    public MicroblockPlacementGrid getPlacementGrid() {
        return CubicPlacementGrid.INSTANCE;
    }

    @Override
    public List<AABB> getModelStrips(PartPlacement placement, @Nullable MicroblockData data) {
        int dir;
        if (placement == PartPlacementsHM.CENTER) {
            return this.itemBoxes;
        }
        if (placement instanceof CubicPartPlacement) {
            CubicPartPlacement cpp = (CubicPartPlacement)placement;
            v0 = cpp.ordinal();
        } else {
            v0 = dir = -1;
        }
        if (dir < 0) {
            return List.of();
        }
        return this.boxes.get(dir);
    }

    @Override
    public VoxelShape getShape(PartPlacement placement, @Nullable MicroblockData data) {
        int dir;
        if (placement instanceof CubicPartPlacement) {
            CubicPartPlacement cpp = (CubicPartPlacement)placement;
            v0 = cpp.ordinal();
        } else {
            v0 = dir = -1;
        }
        if (dir < 0) {
            return Shapes.m_83040_();
        }
        return this.shapes.get(dir);
    }
}

