/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.items.ITabItem;
import org.zeith.hammerlib.event.recipe.BuildTagsEvent;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.item.IMultipartPlacerItem;
import org.zeith.multipart.api.placement.IConfiguredPartPlacer;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PlacedPartConfiguration;
import org.zeith.multipart.microblocks.HammerMicroblocks;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.tile.MicroblockState;
import org.zeith.multipart.microblocks.contents.multipart.MicroblockPartDefinition;
import org.zeith.multipart.microblocks.init.PartDefinitionsHM;
import org.zeith.multipart.microblocks.init.TagsHM;

public class ItemMicroblock
extends Item
implements IMultipartPlacerItem,
ITabItem {
    public static final List<Block> LIMITED_TAB_SELECTION = (List)Util.m_137469_(new ArrayList(), lst -> {
        lst.add(Blocks.f_50069_);
        lst.add(Blocks.f_50493_);
        lst.add(Blocks.f_50440_);
        lst.add(Blocks.f_50705_);
        lst.add(Blocks.f_50741_);
        lst.add(Blocks.f_50742_);
        lst.add(Blocks.f_50743_);
        lst.add(Blocks.f_50744_);
        lst.add(Blocks.f_50745_);
        lst.add(Blocks.f_220865_);
        lst.add(Blocks.f_271304_);
        lst.add(Blocks.f_244477_);
        lst.add(Blocks.f_50655_);
        lst.add(Blocks.f_50656_);
        lst.add(Blocks.f_50075_);
        lst.add(Blocks.f_50074_);
        lst.add(Blocks.f_50090_);
        lst.add(Blocks.f_50268_);
        lst.add(Blocks.f_50060_);
        lst.add(Blocks.f_50041_);
        lst.add(Blocks.f_50042_);
        lst.add(Blocks.f_50096_);
        lst.add(Blocks.f_50097_);
        lst.add(Blocks.f_50098_);
        lst.add(Blocks.f_50099_);
        lst.add(Blocks.f_50100_);
        lst.add(Blocks.f_50101_);
        lst.add(Blocks.f_50102_);
        lst.add(Blocks.f_50103_);
        lst.add(Blocks.f_50104_);
        lst.add(Blocks.f_50105_);
        lst.add(Blocks.f_50106_);
        lst.add(Blocks.f_50107_);
        lst.add(Blocks.f_50108_);
        lst.add(Blocks.f_50109_);
        lst.add(Blocks.f_50542_);
        lst.add(Blocks.f_50543_);
        lst.add(Blocks.f_50544_);
        lst.add(Blocks.f_50545_);
        lst.add(Blocks.f_50494_);
        lst.add(Blocks.f_50495_);
        lst.add(Blocks.f_50496_);
        lst.add(Blocks.f_50497_);
        lst.add(Blocks.f_50498_);
        lst.add(Blocks.f_50499_);
        lst.add(Blocks.f_50500_);
        lst.add(Blocks.f_50501_);
        lst.add(Blocks.f_50502_);
        lst.add(Blocks.f_50503_);
        lst.add(Blocks.f_50504_);
        lst.add(Blocks.f_50505_);
        lst.add(Blocks.f_50080_);
        lst.add(Blocks.f_50134_);
        lst.add(Blocks.f_50197_);
        lst.add(Blocks.f_152497_);
        lst.add(Blocks.f_50137_);
        lst.add(Blocks.f_152490_);
    });

    public ItemMicroblock(Item.Properties props) {
        super(props);
        HammerLib.EVENT_BUS.addListener(this::applyTags);
    }

    public Optional<PlacedPartConfiguration> getPlacement(Level level, BlockPos pos, Player player, ItemStack stack, BlockHitResult hit) {
        MicroblockState state = new MicroblockState();
        MicroblockType mbt = this.getMicroblockType(stack);
        ItemStack mat = this.getMicroblockMaterialStack(stack);
        if (mbt == null || mat.m_41619_()) {
            return Optional.empty();
        }
        PartPlacement placement = mbt.getPlacementGrid().pickPlacement(player, hit, pos.equals((Object)hit.m_82425_()));
        MicroblockData data = mbt.createDataForPlacement(player, hit, pos.equals((Object)hit.m_82425_()));
        state.setType(mbt, data).setMaterial(mat);
        if (placement != null && state.isValid()) {
            return Optional.of(new PlacedPartConfiguration((PartDefinition)PartDefinitionsHM.MICROBLOCK, (IConfiguredPartPlacer)new MicroblockPartDefinition.MicroblockConfiguration(state), placement));
        }
        return Optional.empty();
    }

    private void applyTags(BuildTagsEvent e) {
        if (e.reg.getRegistryKey() == ForgeRegistries.Keys.BLOCKS) {
            ResourceLocation ae2Facades = new ResourceLocation("ae2", "whitelisted/facades");
            List<ResourceLocation> entries = e.tags.getOrDefault(TagsHM.Blocks.MICROBLOCK_BLOCKLIST.f_203868_(), List.of()).stream().map(TagLoader.EntryWithSource::f_216042_).filter(t -> !t.isTag()).map(TagEntry::getId).toList();
            List forced = e.tags.computeIfAbsent(TagsHM.Blocks.MICROBLOCK_ALLOWLIST.f_203868_(), l -> new ArrayList());
            List vals = (List)e.tags.get(ae2Facades);
            if (vals != null && !vals.isEmpty()) {
                for (TagLoader.EntryWithSource val : vals) {
                    if (!val.f_216042_().isTag() && entries.contains(val.f_216042_().getId())) continue;
                    forced.addAll(vals);
                }
                HammerMicroblocks.LOG.info("Added " + ((List)e.tags.get(ae2Facades)).size() + " AE2 facade whitelisted blocks to our own microblock whitelist.");
            }
            HammerMicroblocks.LOG.info("Currently, we have " + forced.size() + " force-white-listed blocks to be slice-able: " + forced.stream().map(e0 -> e0.f_216042_().toString()).collect(Collectors.joining(", ", "[", "]")));
        }
    }

    public String getSubtypeFromStack(ItemStack stack) {
        CompoundTag mcb = stack.m_41737_("Microblock");
        if (mcb != null) {
            ResourceLocation type = ResourceLocation.m_135820_((String)mcb.m_128461_("Type"));
            ResourceLocation itemId = ResourceLocation.m_135820_((String)mcb.m_128461_("Item"));
            return type + ";" + itemId;
        }
        return "null";
    }

    @Nullable
    public MicroblockType getMicroblockType(ItemStack stack) {
        CompoundTag mcb = stack.m_41737_("Microblock");
        if (mcb != null) {
            return (MicroblockType)HammerMicroblocks.microblockTypes().getValue(ResourceLocation.m_135820_((String)mcb.m_128461_("Type")));
        }
        return null;
    }

    @NotNull
    public ItemStack getMicroblockMaterialStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("Microblock");
        if (nbt == null) {
            return ItemStack.f_41583_;
        }
        ResourceLocation itemId = ResourceLocation.m_135820_((String)nbt.m_128461_("Item"));
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemId));
    }

    @Nullable
    public BlockState getMicroblockMaterialState(ItemStack is) {
        ItemStack baseItemStack = this.getMicroblockMaterialStack(is);
        if (baseItemStack.m_41619_()) {
            return null;
        }
        Block block = Block.m_49814_((Item)baseItemStack.m_41720_());
        if (block == Blocks.f_50016_) {
            return null;
        }
        return block.m_49966_();
    }

    public ItemStack forItem(MicroblockType type, ItemStack itemStack, boolean returnItem) {
        return this.forItem(type, itemStack, 1, returnItem);
    }

    public ItemStack forItem(MicroblockType type, ItemStack itemStack, int size, boolean returnItem) {
        Block block;
        if (itemStack.m_41619_() || itemStack.m_41782_() || (block = Block.m_49814_((Item)itemStack.m_41720_())) == Blocks.f_50016_) {
            return ItemStack.f_41583_;
        }
        BlockState blockState = block.m_49966_();
        if (this.allowStateAsFacade(blockState, true)) {
            if (returnItem) {
                return itemStack;
            }
            return this.forItemRaw(type, itemStack, size);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack forItemRaw(MicroblockType type, ItemStack itemStack, int size) {
        ItemStack is = new ItemStack((ItemLike)this, size);
        CompoundTag tag = is.m_41698_("Microblock");
        tag.m_128359_("Item", Objects.toString(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())));
        tag.m_128359_("Type", Objects.toString(HammerMicroblocks.microblockTypes().getKey((Object)type)));
        return is;
    }

    private boolean allowBlockAsFacade(Block block) {
        if (block instanceof AbstractGlassBlock) {
            return true;
        }
        return block instanceof LeavesBlock;
    }

    public boolean allowStateAsFacade(BlockState blockState, boolean checkBlocklist) {
        if (checkBlocklist && blockState.m_204336_(TagsHM.Blocks.MICROBLOCK_BLOCKLIST)) {
            return false;
        }
        boolean forcedByTag = blockState.m_204336_(TagsHM.Blocks.MICROBLOCK_ALLOWLIST);
        boolean isModel = blockState.m_60799_() == RenderShape.MODEL;
        boolean isBlockEntity = blockState.m_155947_();
        boolean isFullCube = blockState.m_60796_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_);
        if (this.allowBlockAsFacade(blockState.m_60734_())) {
            return true;
        }
        return !(!isModel || isBlockEntity && !forcedByTag || !isFullCube && !forcedByTag);
    }

    public Component m_7626_(ItemStack is) {
        try {
            ItemStack in = this.getMicroblockMaterialStack(is);
            MicroblockType type = this.getMicroblockType(is);
            if (!in.m_41619_() && type != null) {
                return Component.m_237110_((String)(this.m_5524_() + "_formatted"), (Object[])new Object[]{type.getDescription(), in.m_41786_()});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.m_7626_(is);
    }

    public void fillItemCategory(CreativeModeTab tab, Set<ItemStack> items) {
        if (!this.allowedIn(tab)) {
            return;
        }
        for (Block b : LIMITED_TAB_SELECTION) {
            try {
                Item item;
                if (!this.allowStateAsFacade(b.m_49966_(), true) || (item = b.m_5456_()) == Items.f_41852_) continue;
                for (MicroblockType type : HammerMicroblocks.microblockTypes()) {
                    ItemStack facade = this.forItem(type, item.m_7968_(), false);
                    if (facade.m_41619_()) continue;
                    items.add(facade);
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    public CreativeModeTab getItemCategory() {
        return HammerMicroblocks.MICROBLOCKS_TAB.tab();
    }
}

