/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.zeith.multipart.microblocks.HammerMicroblocks;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.recipe.MicroblockConversionRecipe;
import org.zeith.multipart.microblocks.api.recipe.MicroblockIngredient;
import org.zeith.multipart.microblocks.api.recipe.MicroblockInput;
import org.zeith.multipart.microblocks.compat.jei.JEIHammerMicroblocks;
import org.zeith.multipart.microblocks.contents.items.ItemSaw;
import org.zeith.multipart.microblocks.init.ItemsHM;

public class MicroblockCuttingCategory
implements IRecipeCategory<MicroblockConversionRecipe> {
    protected final IGuiHelper helper;
    protected final IDrawable background;
    protected final IDrawable icon;
    protected final Component title;

    public MicroblockCuttingCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(new ResourceLocation("textures/gui/container/crafting_table.png"), 29, 16, 116, 54);
        this.icon = helper.createDrawableItemStack(ItemsHM.DIAMOND_SAW.m_7968_());
        this.title = Component.m_237115_((String)"jei.hammermicroblocks.microblock_cutting");
    }

    public RecipeType<MicroblockConversionRecipe> getRecipeType() {
        return JEIHammerMicroblocks.CONVERSION_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MicroblockConversionRecipe recipe, IFocusGroup focuses) {
        ICraftingGridHelper gridHelper = this.helper.createCraftingGridHelper();
        ItemStack materials = Items.f_41905_.m_7968_();
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (MicroblockInput input : recipe.inputs()) {
            minX = Math.min(minX, input.relativeX());
            minY = Math.min(minY, input.relativeY());
            maxX = Math.max(maxX, input.relativeX());
            maxY = Math.max(maxY, input.relativeY());
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        ArrayList inputs = new ArrayList();
        int count = width * height;
        for (int i = 0; i < count; ++i) {
            inputs.add(new ArrayList());
        }
        for (MicroblockInput input : recipe.inputs()) {
            int x = input.relativeX() + minX;
            int y = input.relativeY() + minY;
            List itemsHere = (List)inputs.get(x + y * width);
            MicroblockIngredient obj = input.input();
            if (obj.isFullBlock()) {
                itemsHere.add(materials.m_255036_(1));
                continue;
            }
            HammerMicroblocks.microblockTypes().getValues().stream().filter(obj::matchesType).map(t -> ItemsHM.MICROBLOCK.forItemRaw((MicroblockType)t, materials, 1)).forEach(itemsHere::add);
        }
        ((List)inputs.get(minX + minY * width)).addAll(ItemSaw.all().map(Item::m_7968_).toList());
        gridHelper.createAndSetOutputs(builder, List.of(ItemsHM.MICROBLOCK.forItemRaw(recipe.output(), materials, recipe.count())));
        gridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    public boolean isHandled(MicroblockConversionRecipe recipe) {
        return !recipe.inputs().isEmpty() && recipe.output() != null && recipe.count() > 0;
    }
}

