/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.zeith.multipart.microblocks.HammerMicroblocks;
import org.zeith.multipart.microblocks.api.recipe.GatherMicroblockConversionRecipesEvent;
import org.zeith.multipart.microblocks.api.recipe.MicroblockConversionRecipe;
import org.zeith.multipart.microblocks.api.recipe.combination.GatherMicroblockComboRecipesEvent;
import org.zeith.multipart.microblocks.api.recipe.combination.IMicroblockComboRecipe;
import org.zeith.multipart.microblocks.compat.jei.MicroblockCombinationCategory;
import org.zeith.multipart.microblocks.compat.jei.MicroblockCuttingCategory;
import org.zeith.multipart.microblocks.contents.items.ItemSaw;
import org.zeith.multipart.microblocks.init.ItemsHM;

@JeiPlugin
public class JEIHammerMicroblocks
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = HammerMicroblocks.id("jei");
    public static final RecipeType<MicroblockConversionRecipe> CONVERSION_TYPE = RecipeType.create((String)"hammermicroblocks", (String)"mb_conversions", MicroblockConversionRecipe.class);
    public static final RecipeType<IMicroblockComboRecipe> COMBINATION_TYPE = RecipeType.create((String)"hammermicroblocks", (String)"mb_combinations", IMicroblockComboRecipe.class);

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guih = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MicroblockCuttingCategory(guih), new MicroblockCombinationCategory(guih)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addItemStackInfo(ItemSaw.all().map(Item::m_7968_).toList(), new Component[]{Component.m_237115_((String)"jei.hammermicroblocks.saw_info")});
        registration.addRecipes(CONVERSION_TYPE, GatherMicroblockConversionRecipesEvent.get());
        registration.addRecipes(COMBINATION_TYPE, GatherMicroblockComboRecipesEvent.get());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ItemsHM.MICROBLOCK, (ingredient, context) -> {
            CompoundTag mcb = ingredient.m_41737_("Microblock");
            if (mcb != null) {
                ResourceLocation type = ResourceLocation.m_135820_((String)mcb.m_128461_("Type"));
                return type + ";";
            }
            return "null";
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(Items.f_41960_.m_7968_(), new RecipeType[]{CONVERSION_TYPE});
        registration.addRecipeCatalyst(Items.f_41960_.m_7968_(), new RecipeType[]{COMBINATION_TYPE});
        ItemSaw.all().map(Item::m_7968_).forEach(st -> registration.addRecipeCatalyst(st, new RecipeType[]{CONVERSION_TYPE}));
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }
}

