/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.client.resource.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PartPos;
import org.zeith.multipart.init.PartPlacementsHM;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.contents.microblocks.PlanarMicroblockType;
import org.zeith.multipart.microblocks.contents.multipart.entity.MicroblockEntity;
import org.zeith.multipart.microblocks.shadow.codechicken.lib.model.pipeline.transformers.QuadClamper;
import org.zeith.multipart.microblocks.shadow.codechicken.lib.model.pipeline.transformers.QuadCornerKicker;
import org.zeith.multipart.microblocks.shadow.codechicken.lib.model.pipeline.transformers.QuadReInterpolator;
import org.zeith.multipart.microblocks.shadow.codechicken.lib.model.pipeline.transformers.QuadTinter;
import org.zeith.multipart.microblocks.shadow.fabric.Mesh;
import org.zeith.multipart.microblocks.shadow.fabric.MeshBuilder;
import org.zeith.multipart.microblocks.shadow.fabric.ModelHelper;
import org.zeith.multipart.microblocks.shadow.fabric.QuadEmitter;
import org.zeith.multipart.microblocks.shadow.fabric.Renderer;

public class ModelGeneratorSystem {
    private static final Renderer renderer = Renderer.getInstance();

    public static Mesh generateMesh(List<AABB> holeStrips, ItemStack textureItem, Direction side) {
        MeshBuilder meshBuilder = renderer.meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(textureItem, null, null, 0);
        QuadReInterpolator interpolator = new QuadReInterpolator();
        ItemColors itemColors = Minecraft.m_91087_().getItemColors();
        for (int cullFaceIdx = 0; cullFaceIdx <= 6; ++cullFaceIdx) {
            Direction cullFace = ModelHelper.faceFromIndex(cullFaceIdx);
            List quads = model.m_213637_(null, cullFace, RandomSource.m_216327_());
            for (BakedQuad quad : quads) {
                QuadTinter quadTinter = null;
                if (quad.m_111305_() != -1) {
                    quadTinter = new QuadTinter(itemColors.m_92676_(textureItem, quad.m_111305_()));
                }
                for (AABB box : holeStrips) {
                    emitter.fromVanilla(quad.m_111303_(), 0, false);
                    emitter.cullFace((Direction)(cullFace == side ? side : null));
                    emitter.nominalFace(quad.m_111306_());
                    interpolator.setInputQuad(emitter);
                    QuadClamper clamper = new QuadClamper(box);
                    if (!clamper.transform(emitter)) continue;
                    interpolator.transform(emitter);
                    if (quadTinter != null) {
                        quadTinter.transform(emitter);
                    }
                    emitter.emit();
                }
            }
        }
        return meshBuilder.build();
    }

    public static Mesh generateMesh(MicroblockType type, PartPlacement placement, MicroblockData data, PartContainer pc, BlockAndTintGetter parentWorld, BlockPos pos, List<AABB> holeStrips, BlockState blockState, RandomSource random, RenderType renderType) {
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        MeshBuilder meshBuilder = renderer.meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        float planarThickness = 0.0f;
        int facadeMask = 0;
        Direction planarAttachment = null;
        if (type instanceof PlanarMicroblockType) {
            PlanarMicroblockType pl = (PlanarMicroblockType)type;
            if (placement != null && pc != null) {
                planarThickness = (float)pl.thickness;
                planarAttachment = placement.getDirection();
                if (planarAttachment != null) {
                    for (Direction dir : Direction.values()) {
                        PartEntity part;
                        if (dir.m_122434_() == planarAttachment.m_122434_() || !((part = pc.getPartAt((PartPlacement)PartPlacementsHM.SIDED_PLACEMENT.apply(dir))) instanceof MicroblockEntity)) continue;
                        MicroblockEntity mb = (MicroblockEntity)part;
                        if (!(mb.state.getType() instanceof PlanarMicroblockType)) continue;
                        facadeMask |= 1 << dir.ordinal();
                    }
                }
            }
        }
        FacadeBlockAccess facadeAccess = new FacadeBlockAccess(parentWorld, pos, blockState);
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BakedModel model = dispatcher.m_110910_(blockState);
        AABB fullBounds = type.getShape(placement, data).m_83215_();
        QuadCornerKicker kicker = new QuadCornerKicker();
        if (planarAttachment != null) {
            kicker.setSide(planarAttachment.ordinal());
            kicker.setFacadeMask(facadeMask);
            kicker.setBox(fullBounds);
            kicker.setThickness(planarThickness);
        }
        MicroblockEntity.queryMicroblock.set(new PartPos(pos, placement));
        QuadReInterpolator interpolator = new QuadReInterpolator();
        ModelData modelData = model.getModelData((BlockAndTintGetter)facadeAccess, pos, blockState, ModelData.EMPTY);
        for (int cullFaceIdx = 0; cullFaceIdx <= 6; ++cullFaceIdx) {
            Direction cullFace = ModelHelper.faceFromIndex(cullFaceIdx);
            List<BakedQuad> quads = renderType == null || model.getRenderTypes(blockState, random, modelData).contains(renderType) ? model.getQuads(blockState, cullFace, random, modelData, renderType) : List.of();
            for (BakedQuad quad : quads) {
                QuadTinter quadTinter = null;
                if (quad.m_111305_() != -1) {
                    quadTinter = new QuadTinter(blockColors.m_92577_(blockState, (BlockAndTintGetter)facadeAccess, pos, quad.m_111305_()));
                }
                for (AABB box : holeStrips) {
                    if (quad.m_111306_() != null && (facadeMask & 1 << quad.m_111306_().ordinal()) != 0) {
                        double desired;
                        double axial = switch (quad.m_111306_()) {
                            case Direction.DOWN -> box.f_82289_;
                            case Direction.UP -> box.f_82292_;
                            case Direction.NORTH -> box.f_82290_;
                            case Direction.SOUTH -> box.f_82293_;
                            case Direction.WEST -> box.f_82288_;
                            case Direction.EAST -> box.f_82291_;
                            default -> -1.0;
                        };
                        double d = desired = quad.m_111306_().m_122421_() == Direction.AxisDirection.NEGATIVE ? 0.0 : 1.0;
                        if (Math.abs(axial - desired) < 0.001) continue;
                    }
                    emitter.fromVanilla(quad.m_111303_(), 0, false);
                    emitter.cullFace((Direction)(cullFace == planarAttachment ? planarAttachment : null));
                    emitter.nominalFace(quad.m_111306_());
                    interpolator.setInputQuad(emitter);
                    QuadClamper clamper = new QuadClamper(box);
                    if (!clamper.transform(emitter) || planarAttachment != null && !kicker.transform(emitter)) continue;
                    interpolator.transform(emitter);
                    if (quadTinter != null) {
                        quadTinter.transform(emitter);
                    }
                    emitter.emit();
                }
            }
        }
        MicroblockEntity.queryMicroblock.set(null);
        return meshBuilder.build();
    }

    @Nullable
    private static AEAxisAlignedBB getCutOutBox(AABB facadeBox, List<AABB> partBoxes) {
        AEAxisAlignedBB b = null;
        for (AABB bb : partBoxes) {
            if (!bb.m_82381_(facadeBox)) continue;
            if (b == null) {
                b = AEAxisAlignedBB.fromBounds(bb);
                continue;
            }
            b.maxX = Math.max(b.maxX, bb.f_82291_);
            b.maxY = Math.max(b.maxY, bb.f_82292_);
            b.maxZ = Math.max(b.maxZ, bb.f_82293_);
            b.minX = Math.min(b.minX, bb.f_82288_);
            b.minY = Math.min(b.minY, bb.f_82289_);
            b.minZ = Math.min(b.minZ, bb.f_82290_);
        }
        return b;
    }

    private static List<AABB> getBoxes(AABB fb, AEAxisAlignedBB hole, Direction.Axis axis) {
        if (hole == null) {
            return Collections.singletonList(fb);
        }
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        switch (axis) {
            case Y: {
                boxes.add(new AABB(fb.f_82288_, fb.f_82289_, fb.f_82290_, hole.minX, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(hole.maxX, fb.f_82289_, fb.f_82290_, fb.f_82291_, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(hole.minX, fb.f_82289_, fb.f_82290_, hole.maxX, fb.f_82292_, hole.minZ));
                boxes.add(new AABB(hole.minX, fb.f_82289_, hole.maxZ, hole.maxX, fb.f_82292_, fb.f_82293_));
                break;
            }
            case Z: {
                boxes.add(new AABB(fb.f_82288_, fb.f_82289_, fb.f_82290_, fb.f_82291_, hole.minY, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.maxY, fb.f_82290_, fb.f_82291_, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.minY, fb.f_82290_, hole.minX, hole.maxY, fb.f_82293_));
                boxes.add(new AABB(hole.maxX, hole.minY, fb.f_82290_, fb.f_82291_, hole.maxY, fb.f_82293_));
                break;
            }
            case X: {
                boxes.add(new AABB(fb.f_82288_, fb.f_82289_, fb.f_82290_, fb.f_82291_, hole.minY, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.maxY, fb.f_82290_, fb.f_82291_, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.minY, fb.f_82290_, fb.f_82291_, hole.maxY, hole.minZ));
                boxes.add(new AABB(fb.f_82288_, hole.minY, hole.maxZ, fb.f_82291_, hole.maxY, fb.f_82293_));
                break;
            }
            default: {
                throw new RuntimeException("switch falloff. " + String.valueOf(axis));
            }
        }
        return boxes;
    }

    public static class FacadeBlockAccess
    implements BlockAndTintGetter {
        private final BlockAndTintGetter level;
        private final BlockPos pos;
        private final BlockState state;

        public FacadeBlockAccess(BlockAndTintGetter level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return this.level.m_7702_(pos);
        }

        public BlockState m_8055_(BlockPos pos) {
            if (this.pos == pos) {
                return this.state;
            }
            return this.level.m_8055_(pos);
        }

        public FluidState m_6425_(BlockPos pos) {
            return this.level.m_6425_(pos);
        }

        public float m_7717_(Direction p_230487_1_, boolean p_230487_2_) {
            return this.level.m_7717_(p_230487_1_, p_230487_2_);
        }

        public LevelLightEngine m_5518_() {
            return this.level.m_5518_();
        }

        public int m_6171_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
            return this.level.m_6171_(blockPosIn, colorResolverIn);
        }

        public int m_141928_() {
            return this.level.m_141928_();
        }

        public int m_141937_() {
            return this.level.m_141937_();
        }
    }

    private static class AEAxisAlignedBB {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;

        public AABB getBoundingBox() {
            return new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }

        public AEAxisAlignedBB(double a, double b, double c, double d, double e, double f) {
            this.minX = a;
            this.minY = b;
            this.minZ = c;
            this.maxX = d;
            this.maxY = e;
            this.maxZ = f;
        }

        public static AEAxisAlignedBB fromBounds(double a, double b, double c, double d, double e, double f) {
            return new AEAxisAlignedBB(a, b, c, d, e, f);
        }

        public static AEAxisAlignedBB fromBounds(AABB bb) {
            return new AEAxisAlignedBB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
        }
    }
}

