/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.client.resource.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.zeith.hammerlib.client.model.IBakedModel;
import org.zeith.hammerlib.client.model.IUnbakedGeometry;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.client.resource.model.ModelGeneratorSystem;
import org.zeith.multipart.microblocks.init.ItemsHM;
import org.zeith.multipart.microblocks.init.MicroblockTypesHM;

@LoadUnbakedGeometry(path="microblock_item")
public class MicroblockItemModel
implements IUnbakedGeometry<MicroblockItemModel> {
    public static final ItemTransforms BLOCK_TRANSFORMS = new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0625f, -0.046875f, 0.125f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0625f, -0.046875f, 0.125f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(0.0f, 30.0f, 0.0f), new Vector3f(0.0f, 0.125f, 0.1875f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 30.0f, 0.0f), new Vector3f(0.0f, 0.125f, 0.1875f), new Vector3f(0.4f, 0.4f, 0.4f)), ItemTransform.f_111754_, new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(-0.25f, 0.09375f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransform(new Vector3f(), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransform(new Vector3f(), new Vector3f(), new Vector3f(0.5f, 0.5f, 0.5f)), ImmutableMap.of());

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new BakedMicroblockModelRouter();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return List.of();
    }

    public static class BakedMicroblockModelRouter
    implements IBakedModel {
        public ItemTransforms m_7442_() {
            return BLOCK_TRANSFORMS;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            return List.of();
        }

        public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
            ItemStack state = ItemsHM.MICROBLOCK.getMicroblockMaterialStack(itemStack);
            BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(state);
            return model.getRenderTypes(itemStack, fabulous);
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            ItemStack state = ItemsHM.MICROBLOCK.getMicroblockMaterialStack(itemStack);
            MicroblockType type = ItemsHM.MICROBLOCK.getMicroblockType(itemStack);
            return List.of(new BakedMicroblockModelSpecific(BLOCK_TRANSFORMS, state, (MicroblockType)Cast.or((Object[])new MicroblockType[]{type, MicroblockTypesHM.COVER})));
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
    }

    public static class BakedMicroblockModelSpecific
    implements IBakedModel {
        public final ItemTransforms transforms;
        public final ItemStack blockState;
        public final MicroblockType type;
        private List<BakedQuad> quads = null;

        public BakedMicroblockModelSpecific(ItemTransforms transforms, ItemStack blockState, MicroblockType type) {
            this.transforms = transforms;
            this.blockState = blockState;
            this.type = type;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            if (side != null) {
                return Collections.emptyList();
            }
            if (this.quads == null) {
                List<AABB> aabbs = this.type.getModelStrips(this.type.getPlacementForRendering(), this.type.createItemData());
                this.quads = ModelGeneratorSystem.generateMesh(aabbs, this.blockState, Direction.NORTH).toBakedBlockQuads();
                this.quads = Collections.unmodifiableList(this.quads);
            }
            return this.quads;
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return true;
        }

        public TextureAtlasSprite m_6160_() {
            return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(this.blockState).getParticleIcon(ModelData.EMPTY);
        }
    }
}

